/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.google.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.storm.shade.com.google.common.annotations.Beta;
import org.apache.storm.shade.com.google.common.base.Objects;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.shade.com.google.common.io.ByteSource;
import org.apache.storm.shade.com.google.common.io.ByteStreams;
import org.apache.storm.shade.com.google.common.io.CharSource;
import org.apache.storm.shade.com.google.common.io.CharStreams;
import org.apache.storm.shade.com.google.common.io.InputSupplier;
import org.apache.storm.shade.com.google.common.io.LineProcessor;

@Beta
public final class Resources {
    private Resources() {
    }

    @Deprecated
    public static InputSupplier<InputStream> newInputStreamSupplier(URL url2) {
        return ByteStreams.asInputSupplier(Resources.asByteSource(url2));
    }

    public static ByteSource asByteSource(URL url2) {
        return new UrlByteSource(url2);
    }

    @Deprecated
    public static InputSupplier<InputStreamReader> newReaderSupplier(URL url2, Charset charset2) {
        return CharStreams.asInputSupplier(Resources.asCharSource(url2, charset2));
    }

    public static CharSource asCharSource(URL url2, Charset charset2) {
        return Resources.asByteSource(url2).asCharSource(charset2);
    }

    public static byte[] toByteArray(URL url2) throws IOException {
        return Resources.asByteSource(url2).read();
    }

    public static String toString(URL url2, Charset charset2) throws IOException {
        return Resources.asCharSource(url2, charset2).read();
    }

    public static <T> T readLines(URL url2, Charset charset2, LineProcessor<T> callback) throws IOException {
        return CharStreams.readLines(Resources.newReaderSupplier(url2, charset2), callback);
    }

    public static List<String> readLines(URL url2, Charset charset2) throws IOException {
        return Resources.readLines(url2, charset2, new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    public static void copy(URL from, OutputStream to) throws IOException {
        Resources.asByteSource(from).copyTo(to);
    }

    public static URL getResource(String resourceName) {
        ClassLoader loader2 = Objects.firstNonNull(Thread.currentThread().getContextClassLoader(), Resources.class.getClassLoader());
        URL url2 = loader2.getResource(resourceName);
        Preconditions.checkArgument(url2 != null, "resource %s not found.", resourceName);
        return url2;
    }

    public static URL getResource(Class<?> contextClass, String resourceName) {
        URL url2 = contextClass.getResource(resourceName);
        Preconditions.checkArgument(url2 != null, "resource %s relative to %s not found.", resourceName, contextClass.getName());
        return url2;
    }

    private static final class UrlByteSource
    extends ByteSource {
        private final URL url;

        private UrlByteSource(URL url2) {
            this.url = Preconditions.checkNotNull(url2);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        public String toString() {
            return "Resources.asByteSource(" + this.url + ")";
        }
    }
}

