/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.google.common.eventbus;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.storm.shade.com.google.common.annotations.Beta;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.shade.com.google.common.eventbus.EventBus;
import org.apache.storm.shade.com.google.common.eventbus.EventSubscriber;
import org.apache.storm.shade.com.google.common.eventbus.SubscriberExceptionHandler;

@Beta
public class AsyncEventBus
extends EventBus {
    private final Executor executor;
    private final ConcurrentLinkedQueue<EventBus.EventWithSubscriber> eventsToDispatch = new ConcurrentLinkedQueue();

    public AsyncEventBus(String identifier, Executor executor2) {
        super(identifier);
        this.executor = Preconditions.checkNotNull(executor2);
    }

    public AsyncEventBus(Executor executor2, SubscriberExceptionHandler subscriberExceptionHandler) {
        super(subscriberExceptionHandler);
        this.executor = Preconditions.checkNotNull(executor2);
    }

    public AsyncEventBus(Executor executor2) {
        super("default");
        this.executor = Preconditions.checkNotNull(executor2);
    }

    @Override
    void enqueueEvent(Object event2, EventSubscriber subscriber) {
        this.eventsToDispatch.offer(new EventBus.EventWithSubscriber(event2, subscriber));
    }

    @Override
    protected void dispatchQueuedEvents() {
        EventBus.EventWithSubscriber eventWithSubscriber;
        while ((eventWithSubscriber = this.eventsToDispatch.poll()) != null) {
            this.dispatch(eventWithSubscriber.event, eventWithSubscriber.subscriber);
        }
    }

    @Override
    void dispatch(final Object event2, final EventSubscriber subscriber) {
        Preconditions.checkNotNull(event2);
        Preconditions.checkNotNull(subscriber);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncEventBus.super.dispatch(event2, subscriber);
            }
        });
    }
}

