/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.dataformat.smile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonFactory;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParseException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.storm.shade.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.storm.shade.com.fasterxml.jackson.core.Version;
import org.apache.storm.shade.com.fasterxml.jackson.core.format.InputAccessor;
import org.apache.storm.shade.com.fasterxml.jackson.core.format.MatchStrength;
import org.apache.storm.shade.com.fasterxml.jackson.core.io.IOContext;
import org.apache.storm.shade.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import org.apache.storm.shade.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import org.apache.storm.shade.com.fasterxml.jackson.dataformat.smile.SmileParser;
import org.apache.storm.shade.com.fasterxml.jackson.dataformat.smile.SmileParserBootstrapper;

public class SmileFactory
extends JsonFactory {
    private static final long serialVersionUID = -1696783009312472365L;
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures;
    protected int _smileGeneratorFeatures;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec oc) {
        super(oc);
        this._smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
        this._smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;
    }

    public SmileFactory(SmileFactory src, ObjectCodec oc) {
        super(src, oc);
        this._cfgDelegateToTextual = src._cfgDelegateToTextual;
        this._smileParserFeatures = src._smileParserFeatures;
        this._smileGeneratorFeatures = src._smileGeneratorFeatures;
    }

    @Override
    public SmileFactory copy() {
        this._checkInvalidCopy(SmileFactory.class);
        return new SmileFactory(this, null);
    }

    public void delegateToTextual(boolean state) {
        this._cfgDelegateToTextual = state;
    }

    @Override
    protected Object readResolve() {
        return new SmileFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return SmileParserBootstrapper.hasSmileFormat(acc);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public final SmileFactory configure(SmileParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileParser.Feature f) {
        this._smileParserFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileParser.Feature f) {
        this._smileParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileParser.Feature f) {
        return (this._smileParserFeatures & f.getMask()) != 0;
    }

    public final SmileFactory configure(SmileGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator.Feature f) {
        return (this._smileGeneratorFeatures & f.getMask()) != 0;
    }

    @Override
    public SmileParser createParser(File f) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    @Override
    public SmileParser createParser(URL url2) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(url2), this._createContext(url2, true));
    }

    @Override
    public SmileParser createParser(InputStream in) throws IOException, JsonParseException {
        return this._createParser(in, this._createContext(in, false));
    }

    @Override
    public SmileParser createParser(byte[] data2) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(data2, true);
        return this._createParser(data2, 0, data2.length, ctxt);
    }

    @Override
    public SmileParser createParser(byte[] data2, int offset, int len) throws IOException, JsonParseException {
        return this._createParser(data2, offset, len, this._createContext(data2, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(File f) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(URL url2) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(url2), this._createContext(url2, true));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this._createParser(in, this._createContext(in, false));
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(byte[] data2) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(data2, true);
        return this._createParser(data2, 0, data2.length, ctxt);
    }

    @Override
    @Deprecated
    public SmileParser createJsonParser(byte[] data2, int offset, int len) throws IOException, JsonParseException {
        return this._createParser(data2, offset, len, this._createContext(data2, true));
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    @Override
    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    @Override
    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(out, ctxt);
    }

    @Override
    @Deprecated
    protected SmileGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    @Override
    protected SmileParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(ctxt, in).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(r, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    @Override
    protected SmileParser _createParser(byte[] data2, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(ctxt, data2, offset, len).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(out, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(out, enc, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected SmileGenerator _createGenerator(OutputStream out, IOContext ctxt) throws IOException {
        int feats = this._smileGeneratorFeatures;
        SmileGenerator gen = new SmileGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        if ((feats & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            gen.writeHeader();
        } else {
            if ((feats & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if ((feats & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return gen;
    }
}

