/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.core.json;

import org.apache.storm.shade.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.storm.shade.com.fasterxml.jackson.core.json.DupDetector;

public class JsonWriteContext
extends JsonStreamContext {
    public static final int STATUS_OK_AS_IS = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    protected final JsonWriteContext _parent;
    protected final DupDetector _dups;
    protected JsonWriteContext _child = null;
    protected String _currentName;
    protected boolean _gotName;

    protected JsonWriteContext(int n, JsonWriteContext jsonWriteContext, DupDetector dupDetector) {
        this._type = n;
        this._parent = jsonWriteContext;
        this._dups = dupDetector;
        this._index = -1;
    }

    protected JsonWriteContext reset(int n) {
        this._type = n;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    @Deprecated
    public static JsonWriteContext createRootContext() {
        return JsonWriteContext.createRootContext(null);
    }

    public static JsonWriteContext createRootContext(DupDetector dupDetector) {
        return new JsonWriteContext(0, null, dupDetector);
    }

    public JsonWriteContext createChildArrayContext() {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            this._child = jsonWriteContext = new JsonWriteContext(1, this, this._dups == null ? null : this._dups.child());
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(1);
    }

    public JsonWriteContext createChildObjectContext() {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            this._child = jsonWriteContext = new JsonWriteContext(2, this, this._dups == null ? null : this._dups.child());
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(2);
    }

    @Override
    public final JsonWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public final int writeFieldName(String string) throws JsonProcessingException {
        this._gotName = true;
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
        return this._index < 0 ? 0 : 1;
    }

    private void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            throw new JsonGenerationException("Duplicate field '" + string + "'");
        }
    }

    public final int writeValue() {
        if (this._type == 2) {
            this._gotName = false;
            ++this._index;
            return 2;
        }
        if (this._type == 1) {
            int n;
            return (n = this._index++) < 0 ? 0 : 1;
        }
        ++this._index;
        return this._index == 0 ? 0 : 3;
    }

    protected final void appendDesc(StringBuilder stringBuilder) {
        if (this._type == 2) {
            stringBuilder.append('{');
            if (this._currentName != null) {
                stringBuilder.append('\"');
                stringBuilder.append(this._currentName);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append('}');
        } else if (this._type == 1) {
            stringBuilder.append('[');
            stringBuilder.append(this.getCurrentIndex());
            stringBuilder.append(']');
        } else {
            stringBuilder.append("/");
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.appendDesc(stringBuilder);
        return stringBuilder.toString();
    }
}

