/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.core.json;

import org.apache.storm.shade.com.fasterxml.jackson.core.JsonLocation;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParseException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.storm.shade.com.fasterxml.jackson.core.io.CharTypes;
import org.apache.storm.shade.com.fasterxml.jackson.core.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected final DupDetector _dups;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected JsonReadContext _child = null;

    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n, int n2, int n3) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n;
        this._lineNr = n2;
        this._columnNr = n3;
        this._index = -1;
    }

    protected void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    @Deprecated
    public static JsonReadContext createRootContext(int n, int n2) {
        return JsonReadContext.createRootContext(n, n2, null);
    }

    public static JsonReadContext createRootContext(int n, int n2, DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, n, n2);
    }

    @Deprecated
    public static JsonReadContext createRootContext() {
        return JsonReadContext.createRootContext(null);
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, 1, 0);
    }

    public JsonReadContext createChildArrayContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 1, n, n2);
        } else {
            jsonReadContext.reset(1, n, n2);
        }
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 2, n, n2);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n, n2);
        return jsonReadContext;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    public JsonLocation getStartLocation(Object object) {
        long l = -1L;
        return new JsonLocation(object, l, this._lineNr, this._columnNr);
    }

    public boolean expectComma() {
        int n = ++this._index;
        return this._type != 0 && n > 0;
    }

    public void setCurrentName(String string) throws JsonProcessingException {
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            throw new JsonParseException("Duplicate field '" + string + "'", dupDetector.findLocation());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

