/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.storm.shade.com.fasterxml.jackson.core.io.IOContext;

public final class MergedStream
extends InputStream {
    protected final IOContext _context;
    final InputStream _in;
    byte[] _buffer;
    int _ptr;
    final int _end;

    public MergedStream(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n;
        this._end = n2;
    }

    @Override
    public int available() throws IOException {
        if (this._buffer != null) {
            return this._end - this._ptr;
        }
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this.freeMergedBuffer();
        this._in.close();
    }

    @Override
    public void mark(int n) {
        if (this._buffer == null) {
            this._in.mark(n);
        }
    }

    @Override
    public boolean markSupported() {
        return this._buffer == null && this._in.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this._buffer != null) {
            int n = this._buffer[this._ptr++] & 0xFF;
            if (this._ptr >= this._end) {
                this.freeMergedBuffer();
            }
            return n;
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._buffer != null) {
            int n3 = this._end - this._ptr;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this._buffer, this._ptr, byArray, n, n2);
            this._ptr += n2;
            if (this._ptr >= this._end) {
                this.freeMergedBuffer();
            }
            return n2;
        }
        return this._in.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        if (this._buffer == null) {
            this._in.reset();
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this._buffer != null) {
            int n = this._end - this._ptr;
            if ((long)n > l) {
                this._ptr += (int)l;
                return l;
            }
            this.freeMergedBuffer();
            l2 += (long)n;
            l -= (long)n;
        }
        if (l > 0L) {
            l2 += this._in.skip(l);
        }
        return l2;
    }

    private void freeMergedBuffer() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            if (this._context != null) {
                this._context.releaseReadIOBuffer(byArray);
            }
        }
    }
}

