/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.core.base;

import java.io.IOException;
import org.apache.storm.shade.com.fasterxml.jackson.core.Base64Variant;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParseException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonToken;
import org.apache.storm.shade.com.fasterxml.jackson.core.Version;
import org.apache.storm.shade.com.fasterxml.jackson.core.io.NumberInput;
import org.apache.storm.shade.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import org.apache.storm.shade.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int n) {
        super(n);
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public final int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public JsonToken nextValue() throws IOException, JsonParseException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n;
                continue;
            }
            if (jsonToken.isStructEnd() && --n == 0) break;
        }
        return this;
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public abstract String getCurrentName() throws IOException, JsonParseException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText() throws IOException, JsonParseException;

    @Override
    public abstract char[] getTextCharacters() throws IOException, JsonParseException;

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength() throws IOException, JsonParseException;

    @Override
    public abstract int getTextOffset() throws IOException, JsonParseException;

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1) throws IOException, JsonParseException;

    @Override
    public boolean getValueAsBoolean(boolean bl) throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText().trim();
                    if ("true".equals(string)) {
                        return true;
                    }
                    if ("false".equals(string)) {
                        return false;
                    }
                    if (!this._hasTextualNull(string)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object;
                }
            }
        }
        return bl;
    }

    @Override
    public int getValueAsInt(int n) throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(string, n);
                }
                case 7: 
                case 8: {
                    return this.getIntValue();
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n;
    }

    @Override
    public long getValueAsLong(long l) throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(string, l);
                }
                case 7: 
                case 8: {
                    return this.getLongValue();
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l;
    }

    @Override
    public double getValueAsDouble(double d) throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble(string, d);
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d;
    }

    @Override
    public String getValueAsString(String string) throws IOException, JsonParseException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException, JsonParseException {
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
        }
    }

    @Deprecated
    protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n, String string) throws JsonParseException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructError(string2);
    }

    @Deprecated
    protected void _reportBase64EOF() throws JsonParseException {
        throw this._constructError("Unexpected end-of-String in base64 content");
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected void _reportUnexpectedChar(int n, String string) throws JsonParseException {
        if (n < 0) {
            this._reportInvalidEOF();
        }
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) throws JsonParseException {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _reportInvalidEOFInValue() throws JsonParseException {
        this._reportInvalidEOF(" in a value");
    }

    protected void _reportMissingRootWS(int n) throws JsonParseException {
        this._reportUnexpectedChar(n, "Expected space separating root-level values");
    }

    protected void _throwInvalidSpace(int n) throws JsonParseException {
        char c = (char)n;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n, String string) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n >= 32) {
            char c = (char)n;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c;
        }
        if (c == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c));
        return c;
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) throws JsonParseException {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }
}

