/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.com.fasterxml.jackson.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.shade.com.fasterxml.jackson.core.Base64Variant;
import org.apache.storm.shade.com.fasterxml.jackson.core.Base64Variants;
import org.apache.storm.shade.com.fasterxml.jackson.core.FormatSchema;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.storm.shade.com.fasterxml.jackson.core.JsonToken;
import org.apache.storm.shade.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.storm.shade.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.storm.shade.com.fasterxml.jackson.core.SerializableString;
import org.apache.storm.shade.com.fasterxml.jackson.core.TreeNode;
import org.apache.storm.shade.com.fasterxml.jackson.core.Version;
import org.apache.storm.shade.com.fasterxml.jackson.core.Versioned;
import org.apache.storm.shade.com.fasterxml.jackson.core.io.CharacterEscapes;
import org.apache.storm.shade.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public Object getOutputTarget() {
        return null;
    }

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public final JsonGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public abstract int getFeatureMask();

    public abstract JsonGenerator setFeatureMask(int var1);

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public abstract void writeFieldName(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeString(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public void writeBinary(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n, n2);
    }

    public void writeBinary(byte[] byArray) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n) throws IOException, JsonGenerationException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws IOException, JsonGenerationException;

    public void writeNumber(short s) throws IOException, JsonGenerationException {
        this.writeNumber((int)s);
    }

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public void writeObjectId(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeObjectRef(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeTypeId(Object object) throws IOException, JsonGenerationException {
        throw new JsonGenerationException("No native support for writing Type Ids");
    }

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public abstract void writeTree(TreeNode var1) throws IOException, JsonProcessingException;

    public void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeBooleanField(String string, boolean bl) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeBoolean(bl);
    }

    public final void writeNullField(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNull();
    }

    public final void writeNumberField(String string, int n) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(n);
    }

    public final void writeNumberField(String string, long l) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(l);
    }

    public final void writeNumberField(String string, double d) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(d);
    }

    public final void writeNumberField(String string, float f) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(f);
    }

    public final void writeNumberField(String string, BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string, byte[] byArray) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public final void writeObjectField(String string, Object object) throws IOException, JsonProcessingException {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public void writeOmittedField(String string) throws IOException, JsonGenerationException {
    }

    public void copyCurrentEvent(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        switch (jsonToken.id()) {
            case -1: {
                this._reportError("No current event to copy");
            }
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    this.writeNumber(jsonParser.getIntValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.BIG_INTEGER) {
                    this.writeNumber(jsonParser.getBigIntegerValue());
                    break;
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case 8: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.FLOAT) {
                    this.writeNumber(jsonParser.getFloatValue());
                    break;
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    public void copyCurrentStructure(JsonParser jsonParser) throws IOException, JsonProcessingException {
        int n;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        if ((n = jsonToken.id()) == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
            n = jsonToken.id();
        }
        switch (n) {
            case 1: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    public abstract JsonStreamContext getOutputContext();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean isClosed();

    @Override
    public abstract void close() throws IOException;

    protected void _reportError(String string) throws JsonGenerationException {
        throw new JsonGenerationException(string);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }

    protected void _writeSimpleObject(Object object) throws IOException, JsonGenerationException {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                this.writeNumber(number.intValue());
                return;
            }
            if (number instanceof Long) {
                this.writeNumber(number.longValue());
                return;
            }
            if (number instanceof Double) {
                this.writeNumber(number.doubleValue());
                return;
            }
            if (number instanceof Float) {
                this.writeNumber(number.floatValue());
                return;
            }
            if (number instanceof Short) {
                this.writeNumber(number.shortValue());
                return;
            }
            if (number instanceof Byte) {
                this.writeNumber(number.byteValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeNumber((BigInteger)number);
                return;
            }
            if (number instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number);
                return;
            }
            if (number instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number).get());
                return;
            }
            if (number instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        WRITE_NUMBERS_AS_STRINGS(false),
        WRITE_BIGDECIMAL_AS_PLAIN(false),
        FLUSH_PASSED_TO_STREAM(true),
        ESCAPE_NON_ASCII(false),
        STRICT_DUPLICATE_DETECTION(false);

        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n) {
            return (n & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

