/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.generated.AuthorizationException;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.StormTopology;
import backtype.storm.serialization.DefaultSerializationDelegate;
import backtype.storm.serialization.SerializationDelegate;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.StormBoundedExponentialBackoffRetry;
import backtype.storm.utils.Time;
import backtype.storm.utils.ZookeeperAuthInfo;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.RT;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.shade.org.json.simple.parser.ParseException;
import org.apache.storm.shade.org.yaml.snakeyaml.Yaml;
import org.apache.storm.shade.org.yaml.snakeyaml.constructor.SafeConstructor;
import org.apache.thrift7.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_STREAM_ID = "default";
    private static SerializationDelegate serializationDelegate;

    public static Object newInstance(String klass) {
        try {
            Class<?> c = Class.forName(klass);
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize(Object obj) {
        return serializationDelegate.serialize(obj);
    }

    public static <T> T deserialize(byte[] serialized, Class<T> clazz) {
        return serializationDelegate.deserialize(serialized, clazz);
    }

    public static byte[] javaSerialize(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T javaDeserialize(byte[] serialized, Class<T> clazz) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] gzip(byte[] data2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            out.write(data2);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] gunzip(byte[] data2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(data2);
            GZIPInputStream in = new GZIPInputStream(bis);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
            in.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toCompressedJsonConf(Map<String, Object> stormConf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(new GZIPOutputStream(bos));
            JSONValue.writeJSONString(stormConf, out);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> fromCompressedJsonConf(byte[] serialized) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            InputStreamReader in = new InputStreamReader(new GZIPInputStream(bis));
            Object ret = JSONValue.parseWithException(in);
            in.close();
            return (Map)ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String join(Iterable<T> coll, String sep) {
        Iterator<T> it = coll.iterator();
        String ret = "";
        while (it.hasNext()) {
            ret = ret + it.next();
            if (!it.hasNext()) continue;
            ret = ret + sep;
        }
        return ret;
    }

    public static void sleep(long millis2) {
        try {
            Time.sleep(millis2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<URL> findResources(String name) {
        try {
            Enumeration<URL> resources2 = Thread.currentThread().getContextClassLoader().getResources(name);
            ArrayList<URL> ret = new ArrayList<URL>();
            while (resources2.hasMoreElements()) {
                ret.add(resources2.nextElement());
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map findAndReadConfigFile(String name, boolean mustExist) {
        InputStream in = null;
        boolean confFileEmpty = false;
        try {
            Object yaml;
            in = Utils.getConfigFileInputStream(name);
            if (null != in) {
                yaml = new Yaml(new SafeConstructor());
                Map ret = (Map)((Yaml)yaml).load(new InputStreamReader(in));
                if (null != ret) {
                    HashMap hashMap = new HashMap(ret);
                    return hashMap;
                }
                confFileEmpty = true;
            }
            if (mustExist) {
                if (confFileEmpty) {
                    throw new RuntimeException("Config file " + name + " doesn't have any valid storm configs");
                }
                throw new RuntimeException("Could not find config file on classpath " + name);
            }
            yaml = new HashMap();
            return yaml;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static InputStream getConfigFileInputStream(String configFilePath) throws IOException {
        if (null == configFilePath) {
            throw new IOException("Could not find config file, name not specified");
        }
        HashSet<URL> resources2 = new HashSet<URL>(Utils.findResources(configFilePath));
        if (resources2.isEmpty()) {
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                return new FileInputStream(configFile);
            }
        } else {
            if (resources2.size() > 1) {
                throw new IOException("Found multiple " + configFilePath + " resources. You're probably bundling the Storm jars with your topology jar. " + resources2);
            }
            LOG.info("Using " + configFilePath + " from resources");
            URL resource = resources2.iterator().next();
            return resource.openStream();
        }
        return null;
    }

    public static Map findAndReadConfigFile(String name) {
        return Utils.findAndReadConfigFile(name, true);
    }

    public static Map readDefaultConfig() {
        return Utils.findAndReadConfigFile("defaults.yaml", true);
    }

    public static Map readCommandLineOpts() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getProperty("storm.options");
        if (commandOptions != null) {
            String[] configs;
            for (String config2 : configs = commandOptions.split(",")) {
                String[] options = (config2 = URLDecoder.decode(config2)).split("=", 2);
                if (options.length != 2) continue;
                Object val = options[1];
                try {
                    val = JSONValue.parseWithException(options[1]);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ret.put(options[0], val);
            }
        }
        return ret;
    }

    public static Map readStormConfig() {
        Map ret = Utils.readDefaultConfig();
        String confFile = System.getProperty("storm.conf.file");
        Map storm = confFile == null || confFile.equals("") ? Utils.findAndReadConfigFile("storm.yaml", false) : Utils.findAndReadConfigFile(confFile, true);
        ret.putAll(storm);
        ret.putAll(Utils.readCommandLineOpts());
        return ret;
    }

    private static Object normalizeConf(Object conf) {
        if (conf == null) {
            return new HashMap();
        }
        if (conf instanceof Map) {
            HashMap confMap = new HashMap((Map)conf);
            for (Object key : confMap.keySet()) {
                Object val = confMap.get(key);
                confMap.put(key, Utils.normalizeConf(val));
            }
            return confMap;
        }
        if (conf instanceof List) {
            ArrayList<Object> confList = new ArrayList<Object>((List)conf);
            for (int i = 0; i < confList.size(); ++i) {
                Object val = confList.get(i);
                confList.set(i, Utils.normalizeConf(val));
            }
            return confList;
        }
        if (conf instanceof Integer) {
            return ((Integer)conf).longValue();
        }
        if (conf instanceof Float) {
            return ((Float)conf).doubleValue();
        }
        return conf;
    }

    public static boolean isValidConf(Map<String, Object> stormConf) {
        return Utils.normalizeConf(stormConf).equals(Utils.normalizeConf((Map)JSONValue.parse(JSONValue.toJSONString(stormConf))));
    }

    public static Object getSetComponentObject(ComponentObject obj) {
        if (obj.getSetField() == ComponentObject._Fields.SERIALIZED_JAVA) {
            return Utils.javaDeserialize(obj.get_serialized_java(), Serializable.class);
        }
        if (obj.getSetField() == ComponentObject._Fields.JAVA_OBJECT) {
            return obj.get_java_object();
        }
        return obj.get_shell();
    }

    public static <S, T> T get(Map<S, T> m, S key, T def) {
        T ret = m.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static List<Object> tuple(Object ... values) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(v);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFromMaster(Map conf, String file2, String localFile) throws AuthorizationException, IOException, TException {
        try (NimbusClient client = NimbusClient.getConfiguredClient(conf);){
            Utils.download(client, file2, localFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(NimbusClient client, String file2, String localFile) throws IOException, TException, AuthorizationException {
        try (WritableByteChannel out = Channels.newChannel(new FileOutputStream(localFile));){
            ByteBuffer chunk;
            int written;
            String id = client.getClient().beginFileDownload(file2);
            while ((written = out.write(chunk = client.getClient().downloadChunk(id))) != 0) {
            }
        }
    }

    public static IFn loadClojureFn(String namespace, String name) {
        try {
            Compiler.eval((Object)RT.readString((String)("(require '" + namespace + ")")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (IFn)RT.var((String)namespace, (String)name).deref();
    }

    public static boolean isSystemId(String id) {
        return id.startsWith("__");
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> map) {
        HashMap<V, K> ret = new HashMap<V, K>();
        for (K key : map.keySet()) {
            ret.put(map.get(key), key);
        }
        return ret;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String id) {
        if (topology.get_spouts().containsKey(id)) {
            return topology.get_spouts().get(id).get_common();
        }
        if (topology.get_bolts().containsKey(id)) {
            return topology.get_bolts().get(id).get_common();
        }
        if (topology.get_state_spouts().containsKey(id)) {
            return topology.get_state_spouts().get(id).get_common();
        }
        throw new IllegalArgumentException("Could not find component with id " + id);
    }

    public static Integer getInt(Object o) {
        Integer result2 = Utils.getInt(o, null);
        if (null == result2) {
            throw new IllegalArgumentException("Don't know how to convert null to int");
        }
        return result2;
    }

    public static Integer getInt(Object o, Integer defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).intValue();
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
        } else if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " to int");
    }

    public static boolean getBoolean(Object o, boolean defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " + to boolean");
    }

    public static long secureRandomLong() {
        return UUID.randomUUID().getLeastSignificantBits();
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, String root) {
        return Utils.newCurator(conf, servers, port, root, null);
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        ArrayList<String> serverPorts = new ArrayList<String>();
        for (String zkServer : servers) {
            serverPorts.add(zkServer + ":" + Utils.getInt(port));
        }
        String zkStr = StringUtils.join(serverPorts, ",") + root;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        Utils.setupBuilder(builder, zkStr, conf, auth);
        return builder.build();
    }

    protected static void setupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map conf, ZookeeperAuthInfo auth) {
        builder.connectString(zkStr).connectionTimeoutMs(Utils.getInt(conf.get("storm.zookeeper.connection.timeout"))).sessionTimeoutMs(Utils.getInt(conf.get("storm.zookeeper.session.timeout"))).retryPolicy(new StormBoundedExponentialBackoffRetry(Utils.getInt(conf.get("storm.zookeeper.retry.interval")), Utils.getInt(conf.get("storm.zookeeper.retry.intervalceiling.millis")), Utils.getInt(conf.get("storm.zookeeper.retry.times"))));
        if (auth != null && auth.scheme != null && auth.payload != null) {
            builder = builder.authorization(auth.scheme, auth.payload);
        }
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        return Utils.newCurator(conf, servers, port, "", auth);
    }

    public static CuratorFramework newCuratorStarted(Map conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        CuratorFramework ret = Utils.newCurator(conf, servers, port, root, auth);
        ret.start();
        return ret;
    }

    public static CuratorFramework newCuratorStarted(Map conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        CuratorFramework ret = Utils.newCurator(conf, servers, port, auth);
        ret.start();
        return ret;
    }

    public static TreeMap<Integer, Integer> integerDivided(int sum2, int numPieces) {
        int base = sum2 / numPieces;
        int numInc = sum2 % numPieces;
        int numBases = numPieces - numInc;
        TreeMap<Integer, Integer> ret = new TreeMap<Integer, Integer>();
        ret.put(base, numBases);
        if (numInc != 0) {
            ret.put(base + 1, numInc);
        }
        return ret;
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static void readAndLogStream(String prefix, InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = r.readLine()) != null) {
                LOG.info("{}:{}", (Object)prefix, (Object)line);
            }
        }
        catch (IOException e) {
            LOG.warn("Error whiel trying to log stream", (Throwable)e);
        }
    }

    public static boolean exceptionCauseIsInstanceOf(Class klass, Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!klass.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZkAuthenticationConfiguredStormServer(Map conf) {
        return null != System.getProperty("java.security.auth.login.config") || conf != null && conf.get("storm.zookeeper.auth.scheme") != null && !((String)conf.get("storm.zookeeper.auth.scheme")).isEmpty();
    }

    public static boolean isZkAuthenticationConfiguredTopology(Map conf) {
        return conf != null && conf.get("storm.zookeeper.topology.auth.scheme") != null && !((String)conf.get("storm.zookeeper.topology.auth.scheme")).isEmpty();
    }

    public static List<ACL> getWorkerACL(Map conf) {
        if (!Utils.isZkAuthenticationConfiguredTopology(conf)) {
            return null;
        }
        String stormZKUser = (String)conf.get("storm.zookeeper.superACL");
        if (stormZKUser == null) {
            throw new IllegalArgumentException("Authentication is enabled but storm.zookeeper.superACL is not set");
        }
        String[] split = stormZKUser.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("storm.zookeeper.superACL does not appear to be in the form scheme:acl, i.e. sasl:storm-user");
        }
        ArrayList<ACL> ret = new ArrayList<ACL>(ZooDefs.Ids.CREATOR_ALL_ACL);
        ret.add(new ACL(31, new Id(split[0], split[1])));
        return ret;
    }

    public static String threadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    private static SerializationDelegate getSerializationDelegate(Map stormConf) {
        SerializationDelegate delegate;
        String delegateClassName = (String)stormConf.get("storm.meta.serialization.delegate");
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            delegate = (SerializationDelegate)delegateClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        catch (InstantiationException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        delegate.prepare(stormConf);
        return delegate;
    }

    public static void handleUncaughtException(Throwable t) {
        if (t != null && t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error..." + Thread.currentThread().getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(-1);
            } else {
                throw (Error)t;
            }
        }
    }

    public static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    static {
        Map conf = Utils.readStormConfig();
        serializationDelegate = Utils.getSerializationDelegate(conf);
    }
}

