/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.messaging.IConnection;
import backtype.storm.messaging.TaskMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.storm.shade.com.google.common.collect.Maps;

public class TransferDrainer {
    private HashMap<Integer, ArrayList<ArrayList<TaskMessage>>> bundles = new HashMap();

    public void add(HashMap<Integer, ArrayList<TaskMessage>> taskTupleSetMap) {
        for (Integer task2 : taskTupleSetMap.keySet()) {
            this.addListRefToMap(this.bundles, task2, taskTupleSetMap.get(task2));
        }
    }

    public void send(HashMap<Integer, String> taskToNode, HashMap<String, IConnection> connections) {
        HashMap<String, ArrayList<ArrayList<TaskMessage>>> bundleMapByDestination = this.groupBundleByDestination(taskToNode);
        for (String hostPort : bundleMapByDestination.keySet()) {
            ArrayList<ArrayList<TaskMessage>> bundle;
            Iterator<TaskMessage> iter;
            IConnection connection = connections.get(hostPort);
            if (null == connection || null == (iter = this.getBundleIterator(bundle = bundleMapByDestination.get(hostPort))) || !iter.hasNext()) continue;
            connection.send(iter);
        }
    }

    private HashMap<String, ArrayList<ArrayList<TaskMessage>>> groupBundleByDestination(HashMap<Integer, String> taskToNode) {
        HashMap<String, ArrayList<ArrayList<TaskMessage>>> bundleMap = Maps.newHashMap();
        for (Integer task2 : this.bundles.keySet()) {
            String hostPort = taskToNode.get(task2);
            if (hostPort == null) continue;
            for (ArrayList<TaskMessage> chunk : this.bundles.get(task2)) {
                this.addListRefToMap(bundleMap, hostPort, chunk);
            }
        }
        return bundleMap;
    }

    private <T> void addListRefToMap(HashMap<T, ArrayList<ArrayList<TaskMessage>>> bundleMap, T key, ArrayList<TaskMessage> tuples) {
        ArrayList<ArrayList<TaskMessage>> bundle = bundleMap.get(key);
        if (null == bundle) {
            bundle = new ArrayList();
            bundleMap.put(key, bundle);
        }
        if (null != tuples && tuples.size() > 0) {
            bundle.add(tuples);
        }
    }

    private Iterator<TaskMessage> getBundleIterator(final ArrayList<ArrayList<TaskMessage>> bundle) {
        if (null == bundle) {
            return null;
        }
        return new Iterator<TaskMessage>(){
            private int offset = 0;
            private int size = 0;
            private int bundleOffset;
            private Iterator<TaskMessage> iter;
            {
                for (ArrayList list2 : bundle) {
                    this.size += list2.size();
                }
                this.bundleOffset = 0;
                this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.offset < this.size;
            }

            @Override
            public TaskMessage next() {
                TaskMessage msg = null;
                if (this.iter.hasNext()) {
                    msg = this.iter.next();
                } else {
                    ++this.bundleOffset;
                    this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
                    msg = this.iter.next();
                }
                if (null != msg) {
                    ++this.offset;
                }
                return msg;
            }

            @Override
            public void remove() {
                throw new RuntimeException("not supported");
            }
        };
    }

    public void clear() {
        this.bundles.clear();
    }
}

