/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.generated.Nimbus;
import backtype.storm.security.auth.ThriftClient;
import backtype.storm.security.auth.ThriftConnectionType;
import java.util.Map;
import org.apache.thrift7.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusClient
extends ThriftClient {
    private Nimbus.Client _client;
    private static final Logger LOG = LoggerFactory.getLogger(NimbusClient.class);

    public static NimbusClient getConfiguredClient(Map conf) {
        try {
            String nimbusHost = (String)conf.get("nimbus.host");
            return new NimbusClient(conf, nimbusHost);
        }
        catch (TTransportException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static NimbusClient getConfiguredClientAs(Map conf, String asUser) {
        try {
            if (conf.containsKey("storm.doAsUser")) {
                if (asUser != null && !asUser.isEmpty()) {
                    LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)asUser, conf.get("storm.doAsUser"));
                }
                asUser = (String)conf.get("storm.doAsUser");
            }
            String nimbusHost = (String)conf.get("nimbus.host");
            return new NimbusClient(conf, nimbusHost, null, null, asUser);
        }
        catch (TTransportException ex) {
            throw new RuntimeException(ex);
        }
    }

    public NimbusClient(Map conf, String host, int port) throws TTransportException {
        this(conf, host, port, null);
    }

    public NimbusClient(Map conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, null);
        this._client = new Nimbus.Client(this._protocol);
    }

    public NimbusClient(Map conf, String host, Integer port, Integer timeout, String asUser) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, asUser);
        this._client = new Nimbus.Client(this._protocol);
    }

    public NimbusClient(Map conf, String host) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, null, null, null);
        this._client = new Nimbus.Client(this._protocol);
    }

    public Nimbus.Client getClient() {
        return this._client;
    }
}

