/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.generated.ClusterSummary;
import backtype.storm.generated.ExecutorStats;
import backtype.storm.generated.ExecutorSummary;
import backtype.storm.generated.GetInfoOptions;
import backtype.storm.generated.Nimbus;
import backtype.storm.generated.NumErrorsChoice;
import backtype.storm.generated.TopologyInfo;
import backtype.storm.generated.TopologySummary;
import java.util.HashSet;
import java.util.Map;

public class Monitor {
    private static final String WATCH_TRANSFERRED = "transferred";
    private static final String WATCH_EMITTED = "emitted";
    private int _interval = 4;
    private String _topology;
    private String _component;
    private String _stream;
    private String _watch;

    private HashSet<String> getComponents(Nimbus.Client client, String topology) throws Exception {
        HashSet<String> components = new HashSet<String>();
        ClusterSummary clusterSummary = client.getClusterInfo();
        TopologySummary topologySummary = null;
        for (TopologySummary ts : clusterSummary.get_topologies()) {
            if (!topology.equals(ts.get_name())) continue;
            topologySummary = ts;
            break;
        }
        if (topologySummary == null) {
            throw new IllegalArgumentException("topology: " + topology + " not found");
        }
        String id = topologySummary.get_id();
        GetInfoOptions getInfoOpts = new GetInfoOptions();
        getInfoOpts.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo info2 = client.getTopologyInfoWithOpts(id, getInfoOpts);
        for (ExecutorSummary es : info2.get_executors()) {
            components.add(es.get_component_id());
        }
        return components;
    }

    public void metrics(Nimbus.Client client) throws Exception {
        if (this._interval <= 0) {
            throw new IllegalArgumentException("poll interval must be positive");
        }
        if (this._topology == null || this._topology.isEmpty()) {
            throw new IllegalArgumentException("topology name must be something");
        }
        if (this._component == null || this._component.isEmpty()) {
            HashSet<String> components = this.getComponents(client, this._topology);
            System.out.println("Available components for " + this._topology + " :");
            System.out.println("------------------");
            for (String comp : components) {
                System.out.println(comp);
            }
            System.out.println("------------------");
            System.out.println("Please use -m to specify one component");
            return;
        }
        if (this._stream == null || this._stream.isEmpty()) {
            throw new IllegalArgumentException("stream name must be something");
        }
        if (!WATCH_TRANSFERRED.equals(this._watch) && !WATCH_EMITTED.equals(this._watch)) {
            throw new IllegalArgumentException("watch item must either be transferred or emitted");
        }
        System.out.println("topology\tcomponent\tparallelism\tstream\ttime-diff ms\t" + this._watch + "\tthroughput (Kt/s)");
        long pollMs = this._interval * 1000;
        long now2 = System.currentTimeMillis();
        MetricsState state = new MetricsState(now2, 0L);
        Poller poller = new Poller(now2, pollMs);
        while (true) {
            this.metrics(client, now2, state);
            try {
                now2 = poller.nextPoll();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void metrics(Nimbus.Client client, long now2, MetricsState state) throws Exception {
        long totalStatted = 0L;
        int componentParallelism = 0;
        boolean streamFound = false;
        ClusterSummary clusterSummary = client.getClusterInfo();
        TopologySummary topologySummary = null;
        for (TopologySummary ts : clusterSummary.get_topologies()) {
            if (!this._topology.equals(ts.get_name())) continue;
            topologySummary = ts;
            break;
        }
        if (topologySummary == null) {
            throw new IllegalArgumentException("topology: " + this._topology + " not found");
        }
        String id = topologySummary.get_id();
        GetInfoOptions getInfoOpts = new GetInfoOptions();
        getInfoOpts.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo info2 = client.getTopologyInfoWithOpts(id, getInfoOpts);
        for (ExecutorSummary es : info2.get_executors()) {
            Long stream;
            Map<String, Long> e2;
            Map<String, Map<String, Long>> statted;
            if (!this._component.equals(es.get_component_id())) continue;
            ++componentParallelism;
            ExecutorStats stats2 = es.get_stats();
            if (stats2 == null || (statted = WATCH_EMITTED.equals(this._watch) ? stats2.get_emitted() : stats2.get_transferred()) == null || (e2 = statted.get(":all-time")) == null || (stream = e2.get(this._stream)) == null) continue;
            streamFound = true;
            totalStatted += stream.longValue();
        }
        if (componentParallelism <= 0) {
            HashSet<String> components = this.getComponents(client, this._topology);
            System.out.println("Available components for " + this._topology + " :");
            System.out.println("------------------");
            for (String comp : components) {
                System.out.println(comp);
            }
            System.out.println("------------------");
            throw new IllegalArgumentException("component: " + this._component + " not found");
        }
        if (!streamFound) {
            throw new IllegalArgumentException("stream: " + this._stream + " not found");
        }
        long timeDelta = now2 - state.getLastTime();
        long stattedDelta = totalStatted - state.getLastStatted();
        state.setLastTime(now2);
        state.setLastStatted(totalStatted);
        double throughput = stattedDelta == 0L || timeDelta == 0L ? 0.0 : (double)stattedDelta / (double)timeDelta;
        System.out.println(this._topology + "\t" + this._component + "\t" + componentParallelism + "\t" + this._stream + "\t" + timeDelta + "\t" + stattedDelta + "\t" + throughput);
    }

    public void set_interval(int _interval) {
        this._interval = _interval;
    }

    public void set_topology(String _topology) {
        this._topology = _topology;
    }

    public void set_component(String _component) {
        this._component = _component;
    }

    public void set_stream(String _stream) {
        this._stream = _stream;
    }

    public void set_watch(String _watch) {
        this._watch = _watch;
    }

    private static class Poller {
        private long startTime = 0L;
        private long pollMs = 0L;

        private Poller(long startTime, long pollMs) {
            this.startTime = startTime;
            this.pollMs = pollMs;
        }

        public long nextPoll() throws InterruptedException {
            long now2 = System.currentTimeMillis();
            long cycle = (now2 - this.startTime) / this.pollMs;
            long wakeupTime = this.startTime + this.pollMs * (cycle + 1L);
            long sleepTime = wakeupTime - now2;
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
            now2 = System.currentTimeMillis();
            return now2;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getPollMs() {
            return this.pollMs;
        }

        public void setPollMs(long pollMs) {
            this.pollMs = pollMs;
        }
    }

    private static class MetricsState {
        private long lastTime = 0L;
        private long lastStatted = 0L;

        private MetricsState(long lastTime, long lastStatted) {
            this.lastTime = lastTime;
            this.lastStatted = lastStatted;
        }

        public long getLastStatted() {
            return this.lastStatted;
        }

        public void setLastStatted(long lastStatted) {
            this.lastStatted = lastStatted;
        }

        public long getLastTime() {
            return this.lastTime;
        }

        public void setLastTime(long lastTime) {
            this.lastTime = lastTime;
        }
    }
}

