/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.generated.LocalStateData;
import backtype.storm.generated.ThriftSerializedObject;
import backtype.storm.utils.VersionedStore;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.thrift7.TBase;
import org.apache.thrift7.TDeserializer;
import org.apache.thrift7.TSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalState {
    public static Logger LOG = LoggerFactory.getLogger(LocalState.class);
    private VersionedStore _vs;

    public LocalState(String backingDir) throws IOException {
        LOG.debug("New Local State for {}", (Object)backingDir);
        this._vs = new VersionedStore(backingDir);
    }

    public synchronized Map<String, TBase> snapshot() {
        int attempts = 0;
        while (true) {
            try {
                return this.deserializeLatestVersion();
            }
            catch (Exception e) {
                if (++attempts < 10) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    private Map<String, TBase> deserializeLatestVersion() throws IOException {
        HashMap<String, TBase> result2 = new HashMap<String, TBase>();
        TDeserializer td = new TDeserializer();
        for (Map.Entry<String, ThriftSerializedObject> ent : this.partialDeserializeLatestVersion(td).entrySet()) {
            result2.put(ent.getKey(), this.deserialize(ent.getValue(), td));
        }
        return result2;
    }

    private TBase deserialize(ThriftSerializedObject obj, TDeserializer td) {
        try {
            Class<?> clazz = Class.forName(obj.get_name());
            TBase instance = (TBase)clazz.newInstance();
            td.deserialize(instance, obj.get_bits());
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, ThriftSerializedObject> partialDeserializeLatestVersion(TDeserializer td) {
        try {
            String latestPath = this._vs.mostRecentVersionPath();
            Map<String, ThriftSerializedObject> result2 = new HashMap<String, ThriftSerializedObject>();
            if (latestPath != null) {
                byte[] serialized = FileUtils.readFileToByteArray(new File(latestPath));
                if (serialized.length == 0) {
                    LOG.warn("LocalState file '{}' contained no data, resetting state", (Object)latestPath);
                } else {
                    if (td == null) {
                        td = new TDeserializer();
                    }
                    LocalStateData data2 = new LocalStateData();
                    td.deserialize(data2, serialized);
                    result2 = data2.get_serialized_parts();
                }
            }
            return result2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized Map<String, ThriftSerializedObject> partialSnapshot(TDeserializer td) {
        int attempts = 0;
        while (true) {
            try {
                return this.partialDeserializeLatestVersion(td);
            }
            catch (Exception e) {
                if (++attempts < 10) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public TBase get(String key) {
        TDeserializer td = new TDeserializer();
        Map<String, ThriftSerializedObject> partial = this.partialSnapshot(td);
        ThriftSerializedObject tso = partial.get(key);
        TBase ret = null;
        if (tso != null) {
            ret = this.deserialize(tso, td);
        }
        return ret;
    }

    public void put(String key, TBase val) {
        this.put(key, val, true);
    }

    public synchronized void put(String key, TBase val, boolean cleanup) {
        Map<String, ThriftSerializedObject> curr = this.partialSnapshot(null);
        TSerializer ser = new TSerializer();
        curr.put(key, this.serialize(val, ser));
        this.persistInternal(curr, ser, cleanup);
    }

    public void remove(String key) {
        this.remove(key, true);
    }

    public synchronized void remove(String key, boolean cleanup) {
        Map<String, ThriftSerializedObject> curr = this.partialSnapshot(null);
        curr.remove(key);
        this.persistInternal(curr, null, cleanup);
    }

    public synchronized void cleanup(int keepVersions) throws IOException {
        this._vs.cleanup(keepVersions);
    }

    private void persistInternal(Map<String, ThriftSerializedObject> serialized, TSerializer ser, boolean cleanup) {
        try {
            if (ser == null) {
                ser = new TSerializer();
            }
            byte[] toWrite = ser.serialize(new LocalStateData(serialized));
            String newPath = this._vs.createVersion();
            File file2 = new File(newPath);
            FileUtils.writeByteArrayToFile(file2, toWrite);
            if ((long)toWrite.length != file2.length()) {
                throw new IOException("Tried to serialize " + toWrite.length + " bytes to " + file2.getCanonicalPath() + ", but " + file2.length() + " bytes were written.");
            }
            this._vs.succeedVersion(newPath);
            if (cleanup) {
                this._vs.cleanup(4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ThriftSerializedObject serialize(TBase o, TSerializer ser) {
        try {
            return new ThriftSerializedObject(o.getClass().getName(), ByteBuffer.wrap(ser.serialize(o)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void persist(Map<String, TBase> val, boolean cleanup) {
        try {
            TSerializer ser = new TSerializer();
            HashMap<String, ThriftSerializedObject> serialized = new HashMap<String, ThriftSerializedObject>();
            for (Map.Entry<String, TBase> ent : val.entrySet()) {
                TBase o = ent.getValue();
                serialized.put(ent.getKey(), this.serialize(ent.getValue(), ser));
            }
            this.persistInternal(serialized, ser, cleanup);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

