/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.metric.api.IStatefulObject;
import backtype.storm.utils.MutableObject;
import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DisruptorQueue
implements IStatefulObject {
    static final Object FLUSH_CACHE = new Object();
    static final Object INTERRUPT = new Object();
    RingBuffer<MutableObject> _buffer;
    Sequence _consumer;
    SequenceBarrier _barrier;
    volatile boolean consumerStartedFlag = false;
    ConcurrentLinkedQueue<Object> _cache = new ConcurrentLinkedQueue();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    private static String PREFIX = "disruptor-";
    private String _queueName = "";
    private long _waitTimeout;

    public DisruptorQueue(String queueName, ClaimStrategy claim, WaitStrategy wait, long timeout) {
        this._queueName = PREFIX + queueName;
        this._buffer = new RingBuffer((EventFactory)new ObjectEventFactory(), claim, wait);
        this._consumer = new Sequence();
        this._barrier = this._buffer.newBarrier(new Sequence[0]);
        this._buffer.setGatingSequences(new Sequence[]{this._consumer});
        if (claim instanceof SingleThreadedClaimStrategy) {
            this.consumerStartedFlag = true;
        } else {
            try {
                this.publishDirect(FLUSH_CACHE, true);
            }
            catch (InsufficientCapacityException e) {
                throw new RuntimeException("This code should be unreachable!", e);
            }
        }
        this._waitTimeout = timeout;
    }

    public String getName() {
        return this._queueName;
    }

    public void consumeBatch(EventHandler<Object> handler2) {
        this.consumeBatchToCursor(this._barrier.getCursor(), handler2);
    }

    public void haltWithInterrupt() {
        this.publish(INTERRUPT);
    }

    public void consumeBatchWhenAvailable(EventHandler<Object> handler2) {
        try {
            long availableSequence;
            long nextSequence = this._consumer.get() + 1L;
            long l = availableSequence = this._waitTimeout == 0L ? this._barrier.waitFor(nextSequence) : this._barrier.waitFor(nextSequence, this._waitTimeout, TimeUnit.MILLISECONDS);
            if (availableSequence >= nextSequence) {
                this.consumeBatchToCursor(availableSequence, handler2);
            }
        }
        catch (AlertException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void consumeBatchToCursor(long cursor, EventHandler<Object> handler2) {
        for (long curr = this._consumer.get() + 1L; curr <= cursor; ++curr) {
            try {
                MutableObject mo = (MutableObject)this._buffer.get(curr);
                Object o = mo.o;
                mo.setObject(null);
                if (o == FLUSH_CACHE) {
                    Object c = null;
                    while ((c = this._cache.poll()) != null) {
                        handler2.onEvent(c, curr, true);
                    }
                    continue;
                }
                if (o == INTERRUPT) {
                    throw new InterruptedException("Disruptor processing interrupted");
                }
                handler2.onEvent(o, curr, curr == cursor);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this._consumer.set(cursor);
    }

    public void publish(Object obj) {
        try {
            this.publish(obj, true);
        }
        catch (InsufficientCapacityException ex) {
            throw new RuntimeException("This code should be unreachable!");
        }
    }

    public void tryPublish(Object obj) throws InsufficientCapacityException {
        this.publish(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Object obj, boolean block) throws InsufficientCapacityException {
        boolean publishNow = this.consumerStartedFlag;
        if (!publishNow) {
            this.readLock.lock();
            try {
                publishNow = this.consumerStartedFlag;
                if (!publishNow) {
                    this._cache.add(obj);
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (publishNow) {
            this.publishDirect(obj, block);
        }
    }

    private void publishDirect(Object obj, boolean block) throws InsufficientCapacityException {
        long id = block ? this._buffer.next() : this._buffer.tryNext(1);
        MutableObject m = (MutableObject)this._buffer.get(id);
        m.setObject(obj);
        this._buffer.publish(id);
    }

    public void consumerStarted() {
        this.consumerStartedFlag = true;
        this.writeLock.lock();
        this.writeLock.unlock();
    }

    public long population() {
        return this.writePos() - this.readPos();
    }

    public long capacity() {
        return this._buffer.getBufferSize();
    }

    public long writePos() {
        return this._buffer.getCursor();
    }

    public long readPos() {
        return this._consumer.get();
    }

    public float pctFull() {
        return 1.0f * (float)this.population() / (float)this.capacity();
    }

    @Override
    public Object getState() {
        HashMap<String, Long> state = new HashMap<String, Long>();
        long rp = this.readPos();
        long wp = this.writePos();
        state.put("capacity", this.capacity());
        state.put("population", wp - rp);
        state.put("write_pos", wp);
        state.put("read_pos", rp);
        return state;
    }

    public static class ObjectEventFactory
    implements EventFactory<MutableObject> {
        public MutableObject newInstance() {
            return new MutableObject();
        }
    }
}

