/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class BufferFileInputStream {
    byte[] buffer;
    FileInputStream stream;

    public BufferFileInputStream(String file2, int bufferSize) throws FileNotFoundException {
        this.stream = new FileInputStream(file2);
        this.buffer = new byte[bufferSize];
    }

    public BufferFileInputStream(String file2) throws FileNotFoundException {
        this(file2, 15360);
    }

    public byte[] read() throws IOException {
        int length = this.stream.read(this.buffer);
        if (length == -1) {
            this.close();
            return new byte[0];
        }
        if (length == this.buffer.length) {
            return this.buffer;
        }
        return Arrays.copyOf(this.buffer, length);
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

