/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.transactional.state;

import backtype.storm.transactional.TransactionalSpoutCoordinator;
import backtype.storm.transactional.state.TransactionalState;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class RotatingTransactionalState {
    private TransactionalState _state;
    private String _subdir;
    private boolean _strictOrder;
    private TreeMap<BigInteger, Object> _curr = new TreeMap();

    public RotatingTransactionalState(TransactionalState state, String subdir, boolean strictOrder) {
        this._state = state;
        this._subdir = subdir;
        this._strictOrder = strictOrder;
        state.mkdir(subdir);
        this.sync();
    }

    public RotatingTransactionalState(TransactionalState state, String subdir) {
        this(state, subdir, false);
    }

    public Object getLastState() {
        if (this._curr.isEmpty()) {
            return null;
        }
        return this._curr.lastEntry().getValue();
    }

    public void overrideState(BigInteger txid, Object state) {
        this._state.setData(this.txPath(txid), state);
        this._curr.put(txid, state);
    }

    public void removeState(BigInteger txid) {
        if (this._curr.containsKey(txid)) {
            this._curr.remove(txid);
            this._state.delete(this.txPath(txid));
        }
    }

    public Object getState(BigInteger txid, StateInitializer init) {
        if (!this._curr.containsKey(txid)) {
            Object data2;
            SortedMap<BigInteger, Object> prevMap = this._curr.headMap(txid);
            SortedMap<BigInteger, Object> afterMap = this._curr.tailMap(txid);
            BigInteger prev = null;
            if (!prevMap.isEmpty()) {
                prev = prevMap.lastKey();
            }
            if (this._strictOrder) {
                if (prev == null && !txid.equals(TransactionalSpoutCoordinator.INIT_TXID)) {
                    throw new IllegalStateException("Trying to initialize transaction for which there should be a previous state");
                }
                if (prev != null && !prev.equals(txid.subtract(BigInteger.ONE))) {
                    throw new IllegalStateException("Expecting previous txid state to be the previous transaction");
                }
                if (!afterMap.isEmpty()) {
                    throw new IllegalStateException("Expecting tx state to be initialized in strict order but there are txids after that have state");
                }
            }
            if (afterMap.isEmpty()) {
                Object prevData = prev != null ? this._curr.get(prev) : null;
                data2 = init.init(txid, prevData);
            } else {
                data2 = null;
            }
            this._curr.put(txid, data2);
            this._state.setData(this.txPath(txid), data2);
        }
        return this._curr.get(txid);
    }

    public boolean hasCache(BigInteger txid) {
        return this._curr.containsKey(txid);
    }

    public Object getStateOrCreate(BigInteger txid, StateInitializer init) {
        if (this._curr.containsKey(txid)) {
            return this._curr.get(txid);
        }
        this.getState(txid, init);
        return null;
    }

    public void cleanupBefore(BigInteger txid) {
        SortedMap<BigInteger, Object> toDelete = this._curr.headMap(txid);
        for (BigInteger tx : new HashSet<BigInteger>(toDelete.keySet())) {
            this._curr.remove(tx);
            this._state.delete(this.txPath(tx));
        }
    }

    private void sync() {
        List<String> txids = this._state.list(this._subdir);
        for (String txid_s : txids) {
            Object data2 = this._state.getData(this.txPath(txid_s));
            this._curr.put(new BigInteger(txid_s), data2);
        }
    }

    private String txPath(BigInteger tx) {
        return this.txPath(tx.toString());
    }

    private String txPath(String tx) {
        return this._subdir + "/" + tx;
    }

    public static interface StateInitializer {
        public Object init(BigInteger var1, Object var2);
    }
}

