/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.transactional.partitioned;

import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.transactional.ICommitterTransactionalSpout;
import backtype.storm.transactional.ITransactionalSpout;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.transactional.partitioned.IOpaquePartitionedTransactionalSpout;
import backtype.storm.transactional.state.RotatingTransactionalState;
import backtype.storm.transactional.state.TransactionalState;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OpaquePartitionedTransactionalSpoutExecutor
implements ICommitterTransactionalSpout<Object> {
    IOpaquePartitionedTransactionalSpout _spout;

    public OpaquePartitionedTransactionalSpoutExecutor(IOpaquePartitionedTransactionalSpout spout2) {
        this._spout = spout2;
    }

    @Override
    public ITransactionalSpout.Coordinator<Object> getCoordinator(Map conf, TopologyContext context2) {
        return new Coordinator(conf, context2);
    }

    @Override
    public ICommitterTransactionalSpout.Emitter getEmitter(Map conf, TopologyContext context2) {
        return new Emitter(conf, context2);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._spout.declareOutputFields(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._spout.getComponentConfiguration();
    }

    public class Emitter
    implements ICommitterTransactionalSpout.Emitter {
        IOpaquePartitionedTransactionalSpout.Emitter _emitter;
        TransactionalState _state;
        TreeMap<BigInteger, Map<Integer, Object>> _cachedMetas = new TreeMap();
        Map<Integer, RotatingTransactionalState> _partitionStates = new HashMap<Integer, RotatingTransactionalState>();
        int _index;
        int _numTasks;

        public Emitter(Map conf, TopologyContext context2) {
            this._emitter = OpaquePartitionedTransactionalSpoutExecutor.this._spout.getEmitter(conf, context2);
            this._index = context2.getThisTaskIndex();
            this._numTasks = context2.getComponentTasks(context2.getThisComponentId()).size();
            this._state = TransactionalState.newUserState(conf, (String)conf.get("topology.transactional.id"), OpaquePartitionedTransactionalSpoutExecutor.this.getComponentConfiguration());
            List<String> existingPartitions = this._state.list("");
            for (String p : existingPartitions) {
                int partition = Integer.parseInt(p);
                if ((partition - this._index) % this._numTasks != 0) continue;
                this._partitionStates.put(partition, new RotatingTransactionalState(this._state, p));
            }
        }

        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, BatchOutputCollector collector) {
            HashMap<Integer, Object> metas = new HashMap<Integer, Object>();
            this._cachedMetas.put(tx.getTransactionId(), metas);
            int partitions = this._emitter.numPartitions();
            Map.Entry<BigInteger, Map<Integer, Object>> entry = this._cachedMetas.lowerEntry(tx.getTransactionId());
            Map<Integer, Object> prevCached = entry != null ? entry.getValue() : new HashMap<Integer, Object>();
            for (int i = this._index; i < partitions; i += this._numTasks) {
                RotatingTransactionalState state = this._partitionStates.get(i);
                if (state == null) {
                    state = new RotatingTransactionalState(this._state, "" + i);
                    this._partitionStates.put(i, state);
                }
                state.removeState(tx.getTransactionId());
                Object lastMeta = prevCached.get(i);
                if (lastMeta == null) {
                    lastMeta = state.getLastState();
                }
                Object meta = this._emitter.emitPartitionBatch(tx, collector, i, lastMeta);
                metas.put(i, meta);
            }
        }

        @Override
        public void cleanupBefore(BigInteger txid) {
            for (RotatingTransactionalState state : this._partitionStates.values()) {
                state.cleanupBefore(txid);
            }
        }

        @Override
        public void commit(TransactionAttempt attempt) {
            BigInteger txid = attempt.getTransactionId();
            Map<Integer, Object> metas = this._cachedMetas.remove(txid);
            for (Integer partition : metas.keySet()) {
                Object meta = metas.get(partition);
                this._partitionStates.get(partition).overrideState(txid, meta);
            }
        }

        @Override
        public void close() {
            this._emitter.close();
        }
    }

    public class Coordinator
    implements ITransactionalSpout.Coordinator<Object> {
        IOpaquePartitionedTransactionalSpout.Coordinator _coordinator;

        public Coordinator(Map conf, TopologyContext context2) {
            this._coordinator = OpaquePartitionedTransactionalSpoutExecutor.this._spout.getCoordinator(conf, context2);
        }

        @Override
        public Object initializeTransaction(BigInteger txid, Object prevMetadata) {
            return null;
        }

        @Override
        public boolean isReady() {
            return this._coordinator.isReady();
        }

        @Override
        public void close() {
            this._coordinator.close();
        }
    }
}

