/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.NullStruct;
import backtype.storm.generated.SpoutSpec;
import backtype.storm.generated.StateSpoutSpec;
import backtype.storm.generated.StormTopology;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.grouping.PartialKeyGrouping;
import backtype.storm.topology.BaseConfigurationDeclarer;
import backtype.storm.topology.BasicBoltExecutor;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.ComponentConfigurationDeclarer;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IComponent;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.IRichStateSpout;
import backtype.storm.topology.OutputFieldsGetter;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.json.simple.JSONValue;

public class TopologyBuilder {
    private Map<String, IRichBolt> _bolts = new HashMap<String, IRichBolt>();
    private Map<String, IRichSpout> _spouts = new HashMap<String, IRichSpout>();
    private Map<String, ComponentCommon> _commons = new HashMap<String, ComponentCommon>();
    private Map<String, StateSpoutSpec> _stateSpouts = new HashMap<String, StateSpoutSpec>();

    public StormTopology createTopology() {
        ComponentCommon common2;
        HashMap<String, Bolt> boltSpecs = new HashMap<String, Bolt>();
        HashMap<String, SpoutSpec> spoutSpecs = new HashMap<String, SpoutSpec>();
        for (String boltId : this._bolts.keySet()) {
            IRichBolt bolt2 = this._bolts.get(boltId);
            common2 = this.getComponentCommon(boltId, bolt2);
            boltSpecs.put(boltId, new Bolt(ComponentObject.serialized_java(Utils.javaSerialize(bolt2)), common2));
        }
        for (String spoutId : this._spouts.keySet()) {
            IRichSpout spout2 = this._spouts.get(spoutId);
            common2 = this.getComponentCommon(spoutId, spout2);
            spoutSpecs.put(spoutId, new SpoutSpec(ComponentObject.serialized_java(Utils.javaSerialize(spout2)), common2));
        }
        return new StormTopology(spoutSpecs, boltSpecs, new HashMap<String, StateSpoutSpec>());
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt2) throws IllegalArgumentException {
        return this.setBolt(id, bolt2, null);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt2, Number parallelism_hint2) throws IllegalArgumentException {
        this.validateUnusedId(id);
        this.initCommon(id, bolt2, parallelism_hint2);
        this._bolts.put(id, bolt2);
        return new BoltGetter(id);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt2) throws IllegalArgumentException {
        return this.setBolt(id, bolt2, null);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt2, Number parallelism_hint2) throws IllegalArgumentException {
        return this.setBolt(id, new BasicBoltExecutor(bolt2), parallelism_hint2);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout2) throws IllegalArgumentException {
        return this.setSpout(id, spout2, null);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout2, Number parallelism_hint2) throws IllegalArgumentException {
        this.validateUnusedId(id);
        this.initCommon(id, spout2, parallelism_hint2);
        this._spouts.put(id, spout2);
        return new SpoutGetter(id);
    }

    public void setStateSpout(String id, IRichStateSpout stateSpout) throws IllegalArgumentException {
        this.setStateSpout(id, stateSpout, null);
    }

    public void setStateSpout(String id, IRichStateSpout stateSpout, Number parallelism_hint2) throws IllegalArgumentException {
        this.validateUnusedId(id);
    }

    private void validateUnusedId(String id) {
        if (this._bolts.containsKey(id)) {
            throw new IllegalArgumentException("Bolt has already been declared for id " + id);
        }
        if (this._spouts.containsKey(id)) {
            throw new IllegalArgumentException("Spout has already been declared for id " + id);
        }
        if (this._stateSpouts.containsKey(id)) {
            throw new IllegalArgumentException("State spout has already been declared for id " + id);
        }
    }

    private ComponentCommon getComponentCommon(String id, IComponent component) {
        ComponentCommon ret = new ComponentCommon(this._commons.get(id));
        OutputFieldsGetter getter = new OutputFieldsGetter();
        component.declareOutputFields(getter);
        ret.set_streams(getter.getFieldsDeclaration());
        return ret;
    }

    private void initCommon(String id, IComponent component, Number parallelism) throws IllegalArgumentException {
        Map<String, Object> conf;
        ComponentCommon common2 = new ComponentCommon();
        common2.set_inputs(new HashMap<GlobalStreamId, Grouping>());
        if (parallelism != null) {
            int dop = parallelism.intValue();
            if (dop < 1) {
                throw new IllegalArgumentException("Parallelism must be positive.");
            }
            common2.set_parallelism_hint(dop);
        }
        if ((conf = component.getComponentConfiguration()) != null) {
            common2.set_json_conf(JSONValue.toJSONString(conf));
        }
        this._commons.put(id, common2);
    }

    private static Map parseJson(String json2) {
        if (json2 == null) {
            return new HashMap();
        }
        return (Map)JSONValue.parse(json2);
    }

    private static String mergeIntoJson(Map into, Map newMap) {
        HashMap res = new HashMap(into);
        if (newMap != null) {
            res.putAll(newMap);
        }
        return JSONValue.toJSONString(res);
    }

    protected class BoltGetter
    extends ConfigGetter<BoltDeclarer>
    implements BoltDeclarer {
        private String _boltId;

        public BoltGetter(String boltId) {
            super(boltId);
            this._boltId = boltId;
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, Fields fields2) {
            return this.fieldsGrouping(componentId, "default", fields2);
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, String streamId, Fields fields2) {
            return this.grouping(componentId, streamId, Grouping.fields(fields2.toList()));
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId) {
            return this.globalGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.fields(new ArrayList<String>()));
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId) {
            return this.shuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId) {
            return this.localOrShuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.local_or_shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId) {
            return this.noneGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.none(new NullStruct()));
        }

        @Override
        public BoltDeclarer allGrouping(String componentId) {
            return this.allGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer allGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.all(new NullStruct()));
        }

        @Override
        public BoltDeclarer directGrouping(String componentId) {
            return this.directGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer directGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.direct(new NullStruct()));
        }

        private BoltDeclarer grouping(String componentId, String streamId, Grouping grouping) {
            ((ComponentCommon)TopologyBuilder.this._commons.get(this._boltId)).put_to_inputs(new GlobalStreamId(componentId, streamId), grouping);
            return this;
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields2) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields2));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields2) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields2));
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, CustomStreamGrouping grouping) {
            return this.customGrouping(componentId, "default", grouping);
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, String streamId, CustomStreamGrouping grouping) {
            return this.grouping(componentId, streamId, Grouping.custom_serialized(Utils.javaSerialize(grouping)));
        }

        @Override
        public BoltDeclarer grouping(GlobalStreamId id, Grouping grouping) {
            return this.grouping(id.get_componentId(), id.get_streamId(), grouping);
        }
    }

    protected class SpoutGetter
    extends ConfigGetter<SpoutDeclarer>
    implements SpoutDeclarer {
        public SpoutGetter(String id) {
            super(id);
        }
    }

    protected class ConfigGetter<T extends ComponentConfigurationDeclarer>
    extends BaseConfigurationDeclarer<T> {
        String _id;

        public ConfigGetter(String id) {
            this._id = id;
        }

        @Override
        public T addConfigurations(Map conf) {
            if (conf != null && conf.containsKey("topology.kryo.register")) {
                throw new IllegalArgumentException("Cannot set serializations for a component using fluent API");
            }
            String currConf = ((ComponentCommon)TopologyBuilder.this._commons.get(this._id)).get_json_conf();
            ((ComponentCommon)TopologyBuilder.this._commons.get(this._id)).set_json_conf(TopologyBuilder.mergeIntoJson(TopologyBuilder.parseJson(currConf), conf));
            return (T)this;
        }
    }
}

