/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.FixedTuple;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FixedTupleSpout
implements IRichSpout {
    private static final Map<String, Integer> acked = new HashMap<String, Integer>();
    private static final Map<String, Integer> failed = new HashMap<String, Integer>();
    private List<FixedTuple> _tuples;
    private SpoutOutputCollector _collector;
    private TopologyContext _context;
    private List<FixedTuple> _serveTuples;
    private Map<String, FixedTuple> _pending;
    private String _id = UUID.randomUUID().toString();
    private String _fieldName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumAcked(String stormId) {
        Map<String, Integer> map = acked;
        synchronized (map) {
            return Utils.get(acked, stormId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumFailed(String stormId) {
        Map<String, Integer> map = failed;
        synchronized (map) {
            return Utils.get(failed, stormId, 0);
        }
    }

    public static void clear(String stormId) {
        acked.remove(stormId);
        failed.remove(stormId);
    }

    public FixedTupleSpout(List tuples) {
        this(tuples, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedTupleSpout(List tuples, String fieldName) {
        Object object = acked;
        synchronized (object) {
            acked.put(this._id, 0);
        }
        object = failed;
        synchronized (object) {
            failed.put(this._id, 0);
        }
        this._tuples = new ArrayList<FixedTuple>();
        for (Object o : tuples) {
            FixedTuple ft = o instanceof FixedTuple ? (FixedTuple)o : new FixedTuple((List)o);
            this._tuples.add(ft);
        }
        this._fieldName = fieldName;
    }

    public List<FixedTuple> getSourceTuples() {
        return this._tuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompleted() {
        int failedAmt;
        int ackedAmt;
        Map<String, Integer> map = acked;
        synchronized (map) {
            ackedAmt = acked.get(this._id);
        }
        map = failed;
        synchronized (map) {
            failedAmt = failed.get(this._id);
        }
        return ackedAmt + failedAmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Map<String, Integer> map = acked;
        synchronized (map) {
            acked.remove(this._id);
        }
        map = failed;
        synchronized (map) {
            failed.remove(this._id);
        }
    }

    @Override
    public void open(Map conf, TopologyContext context2, SpoutOutputCollector collector) {
        this._context = context2;
        List<Integer> tasks = context2.getComponentTasks(context2.getThisComponentId());
        for (int startIndex = 0; startIndex < tasks.size() && tasks.get(startIndex).intValue() != context2.getThisTaskId(); ++startIndex) {
        }
        this._collector = collector;
        this._pending = new HashMap<String, FixedTuple>();
        this._serveTuples = new ArrayList<FixedTuple>();
        for (int i = startIndex; i < this._tuples.size(); i += tasks.size()) {
            this._serveTuples.add(this._tuples.get(i));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void nextTuple() {
        if (this._serveTuples.size() > 0) {
            FixedTuple ft = this._serveTuples.remove(0);
            String id = UUID.randomUUID().toString();
            this._pending.put(id, ft);
            this._collector.emit(ft.stream, ft.values, id);
        } else {
            Utils.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ack(Object msgId) {
        Map<String, Integer> map = acked;
        synchronized (map) {
            int curr = Utils.get(acked, this._id, 0);
            acked.put(this._id, curr + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(Object msgId) {
        Map<String, Integer> map = failed;
        synchronized (map) {
            int curr = Utils.get(failed, this._id, 0);
            failed.put(this._id, curr + 1);
        }
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this._fieldName != null) {
            declarer.declare(new Fields(this._fieldName));
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

