/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.AckFailDelegate;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import backtype.storm.utils.InprocMessaging;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FeederSpout
extends BaseRichSpout {
    private int _id = InprocMessaging.acquireNewPort();
    private Fields _outFields;
    private SpoutOutputCollector _collector;
    private AckFailDelegate _ackFailDelegate;

    public FeederSpout(Fields outFields) {
        this._outFields = outFields;
    }

    public void setAckFailDelegate(AckFailDelegate d) {
        this._ackFailDelegate = d;
    }

    public void feed(List<Object> tuple2) {
        this.feed(tuple2, UUID.randomUUID().toString());
    }

    public void feed(List<Object> tuple2, Object msgId) {
        InprocMessaging.sendMessage(this._id, new Values(tuple2, msgId));
    }

    @Override
    public void open(Map conf, TopologyContext context2, SpoutOutputCollector collector) {
        this._collector = collector;
    }

    @Override
    public void close() {
    }

    @Override
    public void nextTuple() {
        List toEmit = (List)InprocMessaging.pollMessage(this._id);
        if (toEmit != null) {
            List tuple2 = (List)toEmit.get(0);
            Object msgId = toEmit.get(1);
            this._collector.emit(tuple2, msgId);
        } else {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void ack(Object msgId) {
        if (this._ackFailDelegate != null) {
            this._ackFailDelegate.ack(msgId);
        }
    }

    @Override
    public void fail(Object msgId) {
        if (this._ackFailDelegate != null) {
            this._ackFailDelegate.fail(msgId);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this._outFields);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return new HashMap<String, Object>();
    }
}

