/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.task;

import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.StormTopology;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.ThriftTopologyUtils;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.json.simple.JSONAware;
import org.apache.storm.shade.org.json.simple.JSONValue;

public class GeneralTopologyContext
implements JSONAware {
    private StormTopology _topology;
    private Map<Integer, String> _taskToComponent;
    private Map<String, List<Integer>> _componentToTasks;
    private Map<String, Map<String, Fields>> _componentToStreamToFields;
    private String _stormId;
    protected Map _stormConf;

    public GeneralTopologyContext(StormTopology topology, Map stormConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId) {
        this._topology = topology;
        this._stormConf = stormConf;
        this._taskToComponent = taskToComponent;
        this._stormId = stormId;
        this._componentToTasks = componentToSortedTasks;
        this._componentToStreamToFields = componentToStreamToFields;
    }

    public String getStormId() {
        return this._stormId;
    }

    public StormTopology getRawTopology() {
        return this._topology;
    }

    public String getComponentId(int taskId) {
        if ((long)taskId == -1L) {
            return "__system";
        }
        return this._taskToComponent.get(taskId);
    }

    public Set<String> getComponentStreams(String componentId) {
        return this.getComponentCommon(componentId).get_streams().keySet();
    }

    public List<Integer> getComponentTasks(String componentId) {
        List<Integer> ret = this._componentToTasks.get(componentId);
        if (ret == null) {
            return new ArrayList<Integer>();
        }
        return new ArrayList<Integer>(ret);
    }

    public Fields getComponentOutputFields(String componentId, String streamId) {
        Fields ret = this._componentToStreamToFields.get(componentId).get(streamId);
        if (ret == null) {
            throw new IllegalArgumentException("No output fields defined for component:stream " + componentId + ":" + streamId);
        }
        return ret;
    }

    public Fields getComponentOutputFields(GlobalStreamId id) {
        return this.getComponentOutputFields(id.get_componentId(), id.get_streamId());
    }

    public Map<GlobalStreamId, Grouping> getSources(String componentId) {
        return this.getComponentCommon(componentId).get_inputs();
    }

    public Map<String, Map<String, Grouping>> getTargets(String componentId) {
        HashMap<String, Map<String, Grouping>> ret = new HashMap<String, Map<String, Grouping>>();
        for (String otherComponentId : this.getComponentIds()) {
            Map<GlobalStreamId, Grouping> inputs = this.getComponentCommon(otherComponentId).get_inputs();
            for (GlobalStreamId id : inputs.keySet()) {
                if (!id.get_componentId().equals(componentId)) continue;
                HashMap<String, Grouping> curr = (HashMap<String, Grouping>)ret.get(id.get_streamId());
                if (curr == null) {
                    curr = new HashMap<String, Grouping>();
                }
                curr.put(otherComponentId, inputs.get(id));
                ret.put(id.get_streamId(), curr);
            }
        }
        return ret;
    }

    @Override
    public String toJSONString() {
        HashMap<String, Map<Integer, String>> obj = new HashMap<String, Map<Integer, String>>();
        obj.put("task->component", this._taskToComponent);
        return JSONValue.toJSONString(obj);
    }

    public Map<Integer, String> getTaskToComponent() {
        return this._taskToComponent;
    }

    public Set<String> getComponentIds() {
        return ThriftTopologyUtils.getComponentIds(this.getRawTopology());
    }

    public ComponentCommon getComponentCommon(String componentId) {
        return ThriftTopologyUtils.getComponentCommon(this.getRawTopology(), componentId);
    }

    public int maxTopologyMessageTimeout() {
        Integer max = Utils.getInt(this._stormConf.get("topology.message.timeout.secs"));
        for (String spout2 : this.getRawTopology().get_spouts().keySet()) {
            Map conf;
            Object comp;
            ComponentCommon common2 = this.getComponentCommon(spout2);
            String jsonConf = common2.get_json_conf();
            if (jsonConf == null || (comp = (conf = (Map)JSONValue.parse(jsonConf)).get("topology.message.timeout.secs")) == null) continue;
            max = Math.max(Utils.getInt(comp), max);
        }
        return max;
    }
}

