/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.ITupleSerializer;
import backtype.storm.serialization.KryoValuesSerializer;
import backtype.storm.serialization.SerializationFactory;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.Tuple;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;

public class KryoTupleSerializer
implements ITupleSerializer {
    KryoValuesSerializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Output _kryoOut;

    public KryoTupleSerializer(Map conf, GeneralTopologyContext context2) {
        this._kryo = new KryoValuesSerializer(conf);
        this._kryoOut = new Output(2000, 2000000000);
        this._ids = new SerializationFactory.IdDictionary(context2.getRawTopology());
    }

    @Override
    public byte[] serialize(Tuple tuple2) {
        try {
            this._kryoOut.clear();
            this._kryoOut.writeInt(tuple2.getSourceTask(), true);
            this._kryoOut.writeInt(this._ids.getStreamId(tuple2.getSourceComponent(), tuple2.getSourceStreamId()), true);
            tuple2.getMessageId().serialize(this._kryoOut);
            this._kryo.serializeInto(tuple2.getValues(), this._kryoOut);
            return this._kryoOut.toBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

