/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.ITupleDeserializer;
import backtype.storm.serialization.KryoValuesDeserializer;
import backtype.storm.serialization.SerializationFactory;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.MessageId;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.TupleImpl;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class KryoTupleDeserializer
implements ITupleDeserializer {
    GeneralTopologyContext _context;
    KryoValuesDeserializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Input _kryoInput;

    public KryoTupleDeserializer(Map conf, GeneralTopologyContext context2) {
        this._kryo = new KryoValuesDeserializer(conf);
        this._context = context2;
        this._ids = new SerializationFactory.IdDictionary(context2.getRawTopology());
        this._kryoInput = new Input(1);
    }

    @Override
    public Tuple deserialize(byte[] ser) {
        try {
            this._kryoInput.setBuffer(ser);
            int taskId = this._kryoInput.readInt(true);
            int streamId = this._kryoInput.readInt(true);
            String componentName = this._context.getComponentId(taskId);
            String streamName = this._ids.getStreamName(componentName, streamId);
            MessageId id = MessageId.deserialize(this._kryoInput);
            List<Object> values = this._kryo.deserializeFrom(this._kryoInput);
            return new TupleImpl(this._context, values, taskId, streamName, id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

