/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.kerberos;

import backtype.storm.security.auth.ReqContext;
import backtype.storm.security.auth.SaslTransportPlugin;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCallbackHandler.class);
    private String userName;

    public ServerCallbackHandler(Configuration configuration, Map stormConf) throws IOException {
        if (configuration == null) {
            return;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("StormServer");
        if (configurationEntries == null) {
            String errorMessage = "Could not find a 'StormServer' entry in this configuration: Server cannot start.";
            LOG.error(errorMessage);
            throw new IOException(errorMessage);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nc) {
        LOG.debug("handleNameCallback");
        this.userName = nc.getDefaultName();
        nc.setName(nc.getDefaultName());
    }

    private void handlePasswordCallback(PasswordCallback pc) {
        LOG.warn("No password found for user: " + this.userName);
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        LOG.info("Successfully authenticated client: authenticationID=" + authenticationID + " authorizationID= " + ac.getAuthorizationID());
        if (ac.getAuthorizationID() == null) {
            ac.setAuthorizedID(authenticationID);
        }
        if (!ac.getAuthenticationID().equals(ac.getAuthorizationID())) {
            ReqContext.context().setRealPrincipal(new SaslTransportPlugin.User(ac.getAuthenticationID()));
        } else {
            ReqContext.context().setRealPrincipal(null);
        }
        ac.setAuthorized(true);
    }
}

