/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.authorizer;

import backtype.storm.security.auth.IAuthorizer;
import backtype.storm.security.auth.ReqContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWhitelistAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWhitelistAuthorizer.class);
    public static String WHITELIST_USERS_CONF = "storm.auth.simple-white-list.users";
    protected Set<String> users;

    @Override
    public void prepare(Map conf) {
        this.users = new HashSet<String>();
        if (conf.containsKey(WHITELIST_USERS_CONF)) {
            this.users.addAll((Collection)conf.get(WHITELIST_USERS_CONF));
        }
    }

    @Override
    public boolean permit(ReqContext context2, String operation, Map topology_conf) {
        LOG.info("[req " + context2.requestID() + "] Access " + " from: " + (context2.remoteAddress() == null ? "null" : context2.remoteAddress().toString()) + (context2.principal() == null ? "" : " principal:" + context2.principal()) + " op:" + operation + (topology_conf == null ? "" : " topoology:" + topology_conf.get("topology.name")));
        return context2.principal() != null ? this.users.contains(context2.principal().getName()) : false;
    }
}

