/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.authorizer;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.IAuthorizer;
import backtype.storm.security.auth.IGroupMappingServiceProvider;
import backtype.storm.security.auth.IPrincipalToLocal;
import backtype.storm.security.auth.ReqContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpersonationAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(ImpersonationAuthorizer.class);
    protected static final String WILD_CARD = "*";
    protected Map<String, ImpersonationACL> userImpersonationACL;
    protected IPrincipalToLocal _ptol;
    protected IGroupMappingServiceProvider _groupMappingProvider;

    @Override
    public void prepare(Map conf) {
        this.userImpersonationACL = new HashMap<String, ImpersonationACL>();
        Map userToHostAndGroup = (Map)conf.get("nimbus.impersonation.acl");
        if (userToHostAndGroup != null) {
            for (String user : userToHostAndGroup.keySet()) {
                ImmutableSet groups = ImmutableSet.copyOf((Collection)((Map)userToHostAndGroup.get(user)).get("groups"));
                ImmutableSet hosts = ImmutableSet.copyOf((Collection)((Map)userToHostAndGroup.get(user)).get("hosts"));
                this.userImpersonationACL.put(user, new ImpersonationACL(user, groups, hosts));
            }
        }
        this._ptol = AuthUtils.GetPrincipalToLocalPlugin(conf);
        this._groupMappingProvider = AuthUtils.GetGroupMappingServiceProviderPlugin(conf);
    }

    @Override
    public boolean permit(ReqContext context2, String operation, Map topology_conf) {
        if (!context2.isImpersonating()) {
            LOG.debug("Not an impersonation attempt.");
            return true;
        }
        String impersonatingPrincipal = context2.realPrincipal().getName();
        String impersonatingUser = this._ptol.toLocal(context2.realPrincipal());
        String userBeingImpersonated = this._ptol.toLocal(context2.principal());
        InetAddress remoteAddress = context2.remoteAddress();
        LOG.info("user = {}, principal = {} is attmepting to impersonate user = {} for operation = {} from host = {}", new Object[]{impersonatingUser, impersonatingPrincipal, userBeingImpersonated, operation, remoteAddress});
        if (!this.userImpersonationACL.containsKey(impersonatingPrincipal) && !this.userImpersonationACL.containsKey(impersonatingUser)) {
            LOG.info("user = {}, principal = {} is trying to impersonate user {}, but config {} does not have entry for impersonating user or principal.Please see SECURITY.MD to learn how to configure users for impersonation.", new Object[]{impersonatingUser, impersonatingPrincipal, userBeingImpersonated, "nimbus.impersonation.acl"});
            return false;
        }
        ImpersonationACL principalACL = this.userImpersonationACL.get(impersonatingPrincipal);
        ImpersonationACL userACL = this.userImpersonationACL.get(impersonatingUser);
        HashSet<String> authorizedHosts = new HashSet<String>();
        HashSet<String> authorizedGroups = new HashSet<String>();
        if (principalACL != null) {
            authorizedHosts.addAll(principalACL.authorizedHosts);
            authorizedGroups.addAll(principalACL.authorizedGroups);
        }
        if (userACL != null) {
            authorizedHosts.addAll(userACL.authorizedHosts);
            authorizedGroups.addAll(userACL.authorizedGroups);
        }
        LOG.debug("user = {}, principal = {} is allowed to impersonate groups = {} from hosts = {} ", new Object[]{impersonatingUser, impersonatingPrincipal, authorizedGroups, authorizedHosts});
        if (!this.isAllowedToImpersonateFromHost(authorizedHosts, remoteAddress)) {
            LOG.info("user = {}, principal = {} is not allowed to impersonate from host {} ", new Object[]{impersonatingUser, impersonatingPrincipal, remoteAddress});
            return false;
        }
        if (!this.isAllowedToImpersonateUser(authorizedGroups, userBeingImpersonated)) {
            LOG.info("user = {}, principal = {} is not allowed to impersonate any group that user {} is part of.", new Object[]{impersonatingUser, impersonatingPrincipal, userBeingImpersonated});
            return false;
        }
        LOG.info("Allowing impersonation of user {} by user {}", (Object)userBeingImpersonated, (Object)impersonatingUser);
        return true;
    }

    private boolean isAllowedToImpersonateFromHost(Set<String> authorizedHosts, InetAddress remoteAddress) {
        return authorizedHosts.contains(WILD_CARD) || authorizedHosts.contains(remoteAddress.getCanonicalHostName()) || authorizedHosts.contains(remoteAddress.getHostName()) || authorizedHosts.contains(remoteAddress.getHostAddress());
    }

    private boolean isAllowedToImpersonateUser(Set<String> authorizedGroups, String userBeingImpersonated) {
        if (authorizedGroups.contains(WILD_CARD)) {
            return true;
        }
        Set<String> groups = null;
        try {
            groups = this._groupMappingProvider.getGroups(userBeingImpersonated);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to get groups for user " + userBeingImpersonated);
        }
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        for (String group : groups) {
            if (!authorizedGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    protected class ImpersonationACL {
        public String impersonatingUser;
        public Set<String> authorizedGroups;
        public Set<String> authorizedHosts;

        private ImpersonationACL(String impersonatingUser, Set<String> authorizedGroups, Set<String> authorizedHosts) {
            this.impersonatingUser = impersonatingUser;
            this.authorizedGroups = authorizedGroups;
            this.authorizedHosts = authorizedHosts;
        }

        public String toString() {
            return "ImpersonationACL{impersonatingUser='" + this.impersonatingUser + '\'' + ", authorizedGroups=" + this.authorizedGroups + ", authorizedHosts=" + this.authorizedHosts + '}';
        }
    }
}

