/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.authorizer;

import backtype.storm.security.auth.IAuthorizer;
import backtype.storm.security.auth.ReqContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DRPCAuthorizerBase
implements IAuthorizer {
    public static Logger LOG = LoggerFactory.getLogger(DRPCAuthorizerBase.class);
    public static final String FUNCTION_NAME = "function.name";

    @Override
    public abstract void prepare(Map var1);

    protected abstract boolean permitClientRequest(ReqContext var1, String var2, Map var3);

    protected abstract boolean permitInvocationRequest(ReqContext var1, String var2, Map var3);

    @Override
    public boolean permit(ReqContext context2, String operation, Map params2) {
        if ("execute".equals(operation)) {
            return this.permitClientRequest(context2, operation, params2);
        }
        if ("failRequest".equals(operation) || "fetchRequest".equals(operation) || "result".equals(operation)) {
            return this.permitInvocationRequest(context2, operation, params2);
        }
        LOG.warn("Denying unsupported operation \"" + operation + "\" from " + context2.remoteAddress());
        return false;
    }
}

