/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.security.auth.ThriftConnectionType;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.thrift7.TProcessor;
import org.apache.thrift7.server.TServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServer.class);
    private Map _storm_conf;
    protected TProcessor _processor = null;
    private final ThriftConnectionType _type;
    private TServer _server = null;
    private Configuration _login_conf;

    public ThriftServer(Map storm_conf, TProcessor processor, ThriftConnectionType type) {
        this._storm_conf = storm_conf;
        this._processor = processor;
        this._type = type;
        try {
            this._login_conf = AuthUtils.GetConfiguration(this._storm_conf);
        }
        catch (Exception x) {
            LOG.error(x.getMessage(), (Throwable)x);
        }
    }

    public void stop() {
        if (this._server != null) {
            this._server.stop();
        }
    }

    public boolean isServing() {
        if (this._server == null) {
            return false;
        }
        return this._server.isServing();
    }

    public void serve() {
        try {
            ITransportPlugin transportPlugin = AuthUtils.GetTransportPlugin(this._type, this._storm_conf, this._login_conf);
            this._server = transportPlugin.getServer(this._processor);
            this._server.serve();
        }
        catch (Exception ex) {
            LOG.error("ThriftServer is being stopped due to: " + ex, (Throwable)ex);
            if (this._server != null) {
                this._server.stop();
            }
            Runtime.getRuntime().halt(1);
        }
    }
}

