/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.security.auth.TBackoffConnect;
import backtype.storm.security.auth.ThriftConnectionType;
import backtype.storm.utils.Utils;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.thrift7.protocol.TBinaryProtocol;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.transport.TSocket;
import org.apache.thrift7.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClient.class);
    private TTransport _transport;
    protected TProtocol _protocol;
    private String _host;
    private Integer _port;
    private Integer _timeout;
    private Map _conf;
    private ThriftConnectionType _type;
    private String _asUser;

    public ThriftClient(Map storm_conf, ThriftConnectionType type, String host) {
        this(storm_conf, type, host, null, null, null);
    }

    public ThriftClient(Map storm_conf, ThriftConnectionType type, String host, Integer port, Integer timeout) {
        this(storm_conf, type, host, port, timeout, null);
    }

    public ThriftClient(Map storm_conf, ThriftConnectionType type, String host, Integer port, Integer timeout, String asUser) {
        if (host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        if (port == null) {
            port = type.getPort(storm_conf);
        }
        if (port <= 0) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this._host = host;
        this._port = port;
        this._timeout = timeout;
        this._conf = storm_conf;
        this._type = type;
        this._asUser = asUser;
        this.reconnect();
    }

    public synchronized TTransport transport() {
        return this._transport;
    }

    public synchronized void reconnect() {
        this.close();
        try {
            TSocket socket = new TSocket(this._host, this._port);
            if (this._timeout != null) {
                socket.setTimeout(this._timeout);
            }
            Configuration login_conf = AuthUtils.GetConfiguration(this._conf);
            ITransportPlugin transportPlugin = AuthUtils.GetTransportPlugin(this._type, this._conf, login_conf);
            TSocket underlyingTransport = socket;
            TBackoffConnect connectionRetry = new TBackoffConnect(Utils.getInt(this._conf.get("storm.nimbus.retry.times")), Utils.getInt(this._conf.get("storm.nimbus.retry.interval.millis")), Utils.getInt(this._conf.get("storm.nimbus.retry.intervalceiling.millis")));
            this._transport = connectionRetry.doConnectWithRetry(transportPlugin, underlyingTransport, this._host, this._asUser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this._protocol = null;
        if (this._transport != null) {
            this._protocol = new TBinaryProtocol(this._transport);
        }
    }

    public synchronized void close() {
        if (this._transport != null) {
            this._transport.close();
            this._transport = null;
            this._protocol = null;
        }
    }
}

