/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.utils.StormBoundedExponentialBackoffRetry;
import java.io.IOException;
import org.apache.thrift7.transport.TTransport;
import org.apache.thrift7.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBackoffConnect {
    private static final Logger LOG = LoggerFactory.getLogger(TBackoffConnect.class);
    private int _completedRetries = 0;
    private int _retryTimes;
    private StormBoundedExponentialBackoffRetry waitGrabber;

    public TBackoffConnect(int retryTimes, int retryInterval, int retryIntervalCeiling) {
        this._retryTimes = retryTimes;
        this.waitGrabber = new StormBoundedExponentialBackoffRetry(retryInterval, retryIntervalCeiling, retryTimes);
    }

    public TTransport doConnectWithRetry(ITransportPlugin transportPlugin, TTransport underlyingTransport, String host, String asUser) throws IOException {
        boolean connected = false;
        TTransport transportResult = null;
        while (!connected) {
            try {
                transportResult = transportPlugin.connect(underlyingTransport, host, asUser);
                connected = true;
            }
            catch (TTransportException ex) {
                this.retryNext(ex);
            }
        }
        return transportResult;
    }

    private void retryNext(TTransportException ex) {
        if (!this.canRetry()) {
            throw new RuntimeException(ex);
        }
        try {
            int sleeptime = this.waitGrabber.getSleepTimeMs(this._completedRetries, 0L);
            LOG.debug("Failed to connect. Retrying... (" + Integer.toString(this._completedRetries) + ") in " + Integer.toString(sleeptime) + "ms");
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException e) {
            LOG.info("Nimbus connection retry interrupted.");
        }
        ++this._completedRetries;
    }

    private boolean canRetry() {
        return this._completedRetries < this._retryTimes;
    }
}

