/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.IGroupMappingServiceProvider;
import backtype.storm.utils.ShellUtils;
import backtype.storm.utils.TimeCacheMap;
import backtype.storm.utils.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellBasedGroupsMapping
implements IGroupMappingServiceProvider {
    public static Logger LOG = LoggerFactory.getLogger(ShellBasedGroupsMapping.class);
    public TimeCacheMap<String, Set<String>> cachedGroups;

    @Override
    public void prepare(Map storm_conf) {
        int timeout = Utils.getInt(storm_conf.get("storm.group.mapping.service.cache.duration.secs"));
        this.cachedGroups = new TimeCacheMap(timeout);
    }

    @Override
    public Set<String> getGroups(String user) throws IOException {
        if (this.cachedGroups.containsKey(user)) {
            return this.cachedGroups.get(user);
        }
        Set<String> groups = ShellBasedGroupsMapping.getUnixGroups(user);
        if (!groups.isEmpty()) {
            this.cachedGroups.put(user, groups);
        }
        return groups;
    }

    private static Set<String> getUnixGroups(String user) throws IOException {
        String result2 = "";
        try {
            result2 = ShellUtils.execCommand(ShellUtils.getGroupsForUserCommand(user));
        }
        catch (ShellUtils.ExitCodeException e) {
            LOG.warn("got exception trying to get groups for user " + user, (Throwable)e);
            return new HashSet<String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(result2, ShellUtils.TOKEN_SEPARATOR_REGEX);
        HashSet<String> groups = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }
}

