/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.security.auth.ReqContext;
import backtype.storm.security.auth.ThriftConnectionType;
import backtype.storm.utils.ExtendedThreadPoolExecutor;
import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.sasl.SaslServer;
import org.apache.thrift7.TException;
import org.apache.thrift7.TProcessor;
import org.apache.thrift7.protocol.TBinaryProtocol;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.server.TServer;
import org.apache.thrift7.server.TThreadPoolServer;
import org.apache.thrift7.transport.TSaslServerTransport;
import org.apache.thrift7.transport.TServerSocket;
import org.apache.thrift7.transport.TSocket;
import org.apache.thrift7.transport.TTransport;
import org.apache.thrift7.transport.TTransportException;
import org.apache.thrift7.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaslTransportPlugin
implements ITransportPlugin {
    protected ThriftConnectionType type;
    protected Map storm_conf;
    protected Configuration login_conf;
    private static final Logger LOG = LoggerFactory.getLogger(SaslTransportPlugin.class);

    @Override
    public void prepare(ThriftConnectionType type, Map storm_conf, Configuration login_conf) {
        this.type = type;
        this.storm_conf = storm_conf;
        this.login_conf = login_conf;
    }

    @Override
    public TServer getServer(TProcessor processor) throws IOException, TTransportException {
        int port = this.type.getPort(this.storm_conf);
        TTransportFactory serverTransportFactory = this.getServerTransportFactory();
        TServerSocket serverTransport = new TServerSocket(port);
        int numWorkerThreads = this.type.getNumThreads(this.storm_conf);
        Integer queueSize = this.type.getQueueSize(this.storm_conf);
        TThreadPoolServer.Args server_args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(new TUGIWrapProcessor(processor))).minWorkerThreads(numWorkerThreads).maxWorkerThreads(numWorkerThreads).protocolFactory(new TBinaryProtocol.Factory(false, true));
        if (serverTransportFactory != null) {
            server_args.transportFactory(serverTransportFactory);
        }
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue();
        if (queueSize != null) {
            workQueue = new ArrayBlockingQueue(queueSize);
        }
        ExtendedThreadPoolExecutor executorService = new ExtendedThreadPoolExecutor(numWorkerThreads, numWorkerThreads, 60L, TimeUnit.SECONDS, workQueue);
        server_args.executorService(executorService);
        return new TThreadPoolServer(server_args);
    }

    protected abstract TTransportFactory getServerTransportFactory() throws IOException;

    public static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.name.equals(((User)o).name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class TUGIWrapProcessor
    implements TProcessor {
        final TProcessor wrapped;

        TUGIWrapProcessor(TProcessor wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
            ReqContext req_context = ReqContext.context();
            TTransport trans = inProt.getTransport();
            TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
            TSocket tsocket = (TSocket)saslTrans.getUnderlyingTransport();
            Socket socket = tsocket.getSocket();
            req_context.setRemoteAddress(socket.getInetAddress());
            SaslServer saslServer = saslTrans.getSaslServer();
            String authId = saslServer.getAuthorizationID();
            Subject remoteUser = new Subject();
            remoteUser.getPrincipals().add(new User(authId));
            req_context.setSubject(remoteUser);
            return this.wrapped.process(inProt, outProt);
        }
    }
}

