/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.IHttpCredentialsPlugin;
import backtype.storm.security.auth.ReqContext;
import backtype.storm.security.auth.SingleUserPrincipal;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpCredentialsPlugin
implements IHttpCredentialsPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpCredentialsPlugin.class);

    @Override
    public void prepare(Map storm_conf) {
    }

    @Override
    public String getUserName(HttpServletRequest req) {
        String userName;
        Principal princ = null;
        if (req != null && (princ = req.getUserPrincipal()) != null && (userName = princ.getName()) != null && !userName.isEmpty()) {
            LOG.debug("HTTP request had user (" + userName + ")");
            return userName;
        }
        return null;
    }

    @Override
    public ReqContext populateContext(ReqContext context2, HttpServletRequest req) {
        String userName = this.getUserName(req);
        String doAsUser = req.getHeader("doAsUser");
        if (doAsUser == null) {
            doAsUser = req.getParameter("doAsUser");
        }
        if (doAsUser != null) {
            context2.setRealPrincipal(new SingleUserPrincipal(userName));
            userName = doAsUser;
        }
        HashSet<SingleUserPrincipal> principals = new HashSet<SingleUserPrincipal>();
        if (userName != null) {
            SingleUserPrincipal p = new SingleUserPrincipal(userName);
            principals.add(p);
        }
        Subject s = new Subject(true, principals, new HashSet(), new HashSet());
        context2.setSubject(s);
        return context2;
    }
}

