/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.INimbusCredentialPlugin;
import backtype.storm.security.auth.IAutoCredentials;
import backtype.storm.security.auth.ICredentialsRenewer;
import backtype.storm.security.auth.IGroupMappingServiceProvider;
import backtype.storm.security.auth.IHttpCredentialsPlugin;
import backtype.storm.security.auth.IPrincipalToLocal;
import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.security.auth.ThriftConnectionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.URIParameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthUtils.class);
    public static final String LOGIN_CONTEXT_SERVER = "StormServer";
    public static final String LOGIN_CONTEXT_CLIENT = "StormClient";
    public static final String SERVICE = "storm_thrift_server";

    public static Configuration GetConfiguration(Map storm_conf) {
        Configuration login_conf = null;
        String loginConfigurationFile = (String)storm_conf.get("java.security.auth.login.config");
        if (loginConfigurationFile != null && loginConfigurationFile.length() > 0) {
            File config_file = new File(loginConfigurationFile);
            if (!config_file.canRead()) {
                throw new RuntimeException("File " + loginConfigurationFile + " cannot be read.");
            }
            try {
                URI config_uri = config_file.toURI();
                login_conf = Configuration.getInstance("JavaLoginConfig", new URIParameter(config_uri));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return login_conf;
    }

    public static IPrincipalToLocal GetPrincipalToLocalPlugin(Map storm_conf) {
        IPrincipalToLocal ptol = null;
        try {
            String ptol_klassName = (String)storm_conf.get("storm.principal.tolocal");
            Class<?> klass = Class.forName(ptol_klassName);
            ptol = (IPrincipalToLocal)klass.newInstance();
            ptol.prepare(storm_conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ptol;
    }

    public static IGroupMappingServiceProvider GetGroupMappingServiceProviderPlugin(Map storm_conf) {
        IGroupMappingServiceProvider gmsp = null;
        try {
            String gmsp_klassName = (String)storm_conf.get("storm.group.mapping.service");
            Class<?> klass = Class.forName(gmsp_klassName);
            gmsp = (IGroupMappingServiceProvider)klass.newInstance();
            gmsp.prepare(storm_conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return gmsp;
    }

    public static Collection<ICredentialsRenewer> GetCredentialRenewers(Map conf) {
        try {
            HashSet<ICredentialsRenewer> ret = new HashSet<ICredentialsRenewer>();
            Collection clazzes = (Collection)conf.get("nimbus.credential.renewers.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    ICredentialsRenewer inst = (ICredentialsRenewer)Class.forName(clazz).newInstance();
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<INimbusCredentialPlugin> getNimbusAutoCredPlugins(Map conf) {
        try {
            HashSet<INimbusCredentialPlugin> ret = new HashSet<INimbusCredentialPlugin>();
            Collection clazzes = (Collection)conf.get("nimbus.autocredential.plugins.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    INimbusCredentialPlugin inst = (INimbusCredentialPlugin)Class.forName(clazz).newInstance();
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<IAutoCredentials> GetAutoCredentials(Map storm_conf) {
        try {
            HashSet<IAutoCredentials> autos = new HashSet<IAutoCredentials>();
            Collection clazzes = (Collection)storm_conf.get("topology.auto-credentials");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    IAutoCredentials a = (IAutoCredentials)Class.forName(clazz).newInstance();
                    a.prepare(storm_conf);
                    autos.add(a);
                }
            }
            LOG.info("Got AutoCreds " + autos);
            return autos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Subject populateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        try {
            if (subject == null) {
                subject = new Subject();
            }
            for (IAutoCredentials autoCred : autos) {
                autoCred.populateSubject(subject, credentials);
            }
            return subject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        if (subject == null) {
            throw new RuntimeException("The subject cannot be null when updating a subject with credentials");
        }
        try {
            for (IAutoCredentials autoCred : autos) {
                autoCred.updateSubject(subject, credentials);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ITransportPlugin GetTransportPlugin(ThriftConnectionType type, Map storm_conf, Configuration login_conf) {
        ITransportPlugin transportPlugin = null;
        try {
            String transport_plugin_klassName = type.getTransportPlugin(storm_conf);
            Class<?> klass = Class.forName(transport_plugin_klassName);
            transportPlugin = (ITransportPlugin)klass.newInstance();
            transportPlugin.prepare(type, storm_conf, login_conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return transportPlugin;
    }

    private static IHttpCredentialsPlugin GetHttpCredentialsPlugin(Map conf, String klassName) {
        IHttpCredentialsPlugin plugin = null;
        try {
            Class<?> klass = Class.forName(klassName);
            plugin = (IHttpCredentialsPlugin)klass.newInstance();
            plugin.prepare(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return plugin;
    }

    public static IHttpCredentialsPlugin GetUiHttpCredentialsPlugin(Map conf) {
        String klassName = (String)conf.get("ui.http.creds.plugin");
        return AuthUtils.GetHttpCredentialsPlugin(conf, klassName);
    }

    public static IHttpCredentialsPlugin GetDrpcHttpCredentialsPlugin(Map conf) {
        String klassName = (String)conf.get("drpc.http.creds.plugin");
        return AuthUtils.GetHttpCredentialsPlugin(conf, klassName);
    }

    public static String get(Configuration configuration, String section, String key) throws IOException {
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(section);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + section + "' entry in this configuration.";
            throw new IOException(errorMessage);
        }
        for (AppConfigurationEntry entry : configurationEntries) {
            Object val = entry.getOptions().get(key);
            if (val == null) continue;
            return (String)val;
        }
        return null;
    }

    public static byte[] serializeKerberosTicket(KerberosTicket tgt) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bao);
        out.writeObject(tgt);
        out.flush();
        out.close();
        return bao.toByteArray();
    }

    public static KerberosTicket deserializeKerberosTicket(byte[] tgtBytes) {
        KerberosTicket ret;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(tgtBytes);
            ObjectInputStream in = new ObjectInputStream(bin);
            ret = (KerberosTicket)in.readObject();
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static KerberosTicket cloneKerberosTicket(KerberosTicket kerberosTicket) {
        if (kerberosTicket != null) {
            try {
                return AuthUtils.deserializeKerberosTicket(AuthUtils.serializeKerberosTicket(kerberosTicket));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clone KerberosTicket TGT!!", e);
            }
        }
        return null;
    }
}

