/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.scheduler.multitenant;

import backtype.storm.scheduler.Cluster;
import backtype.storm.scheduler.ExecutorDetails;
import backtype.storm.scheduler.SchedulerAssignment;
import backtype.storm.scheduler.SupervisorDetails;
import backtype.storm.scheduler.WorkerSlot;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node {
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private Map<String, Set<WorkerSlot>> _topIdToUsedSlots = new HashMap<String, Set<WorkerSlot>>();
    private Set<WorkerSlot> _freeSlots = new HashSet<WorkerSlot>();
    private final String _nodeId;
    private boolean _isAlive;
    public static final Comparator<Node> FREE_NODE_COMPARATOR_DEC = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return o2.totalSlotsFree() - o1.totalSlotsFree();
        }
    };

    public Node(String nodeId, Set<Integer> allPorts, boolean isAlive) {
        this._nodeId = nodeId;
        this._isAlive = isAlive;
        if (this._isAlive && allPorts != null) {
            for (int port : allPorts) {
                this._freeSlots.add(new WorkerSlot(this._nodeId, port));
            }
        }
    }

    public String getId() {
        return this._nodeId;
    }

    public boolean isAlive() {
        return this._isAlive;
    }

    public Collection<String> getRunningTopologies() {
        return this._topIdToUsedSlots.keySet();
    }

    public boolean isTotallyFree() {
        return this._topIdToUsedSlots.isEmpty();
    }

    public int totalSlotsFree() {
        return this._freeSlots.size();
    }

    public int totalSlotsUsed() {
        int total = 0;
        for (Set<WorkerSlot> slots : this._topIdToUsedSlots.values()) {
            total += slots.size();
        }
        return total;
    }

    public int totalSlots() {
        return this.totalSlotsFree() + this.totalSlotsUsed();
    }

    public int totalSlotsUsed(String topId) {
        int total = 0;
        Set<WorkerSlot> slots = this._topIdToUsedSlots.get(topId);
        if (slots != null) {
            total = slots.size();
        }
        return total;
    }

    private void validateSlot(WorkerSlot ws) {
        if (!this._nodeId.equals(ws.getNodeId())) {
            throw new IllegalArgumentException("Trying to add a slot to the wrong node " + ws + " is not a part of " + this._nodeId);
        }
    }

    private void addOrphanedSlot(WorkerSlot ws) {
        if (this._isAlive) {
            throw new IllegalArgumentException("Orphaned Slots only are allowed on dead nodes.");
        }
        this.validateSlot(ws);
        if (this._freeSlots.contains(ws)) {
            return;
        }
        for (Set<WorkerSlot> used : this._topIdToUsedSlots.values()) {
            if (!used.contains(ws)) continue;
            return;
        }
        this._freeSlots.add(ws);
    }

    boolean assignInternal(WorkerSlot ws, String topId, boolean dontThrow) {
        Set<WorkerSlot> usedSlots;
        this.validateSlot(ws);
        if (!this._freeSlots.remove(ws)) {
            for (Map.Entry<String, Set<WorkerSlot>> topologySetEntry : this._topIdToUsedSlots.entrySet()) {
                if (!topologySetEntry.getValue().contains(ws)) continue;
                if (dontThrow) {
                    LOG.warn("Worker slot [" + ws + "] can't be assigned to " + topId + ". Its already assigned to " + topologySetEntry.getKey() + ".");
                    return true;
                }
                throw new IllegalStateException("Worker slot [" + ws + "] can't be assigned to " + topId + ". Its already assigned to " + topologySetEntry.getKey() + ".");
            }
            LOG.warn("Adding Worker slot [" + ws + "] that was not reported in the supervisor heartbeats," + " but the worker is already running for topology " + topId + ".");
        }
        if ((usedSlots = this._topIdToUsedSlots.get(topId)) == null) {
            usedSlots = new HashSet<WorkerSlot>();
            this._topIdToUsedSlots.put(topId, usedSlots);
        }
        usedSlots.add(ws);
        return false;
    }

    public void freeAllSlots(Cluster cluster2) {
        if (!this._isAlive) {
            LOG.warn("Freeing all slots on a dead node {} ", (Object)this._nodeId);
        }
        for (Map.Entry<String, Set<WorkerSlot>> entry : this._topIdToUsedSlots.entrySet()) {
            cluster2.freeSlots((Collection<WorkerSlot>)entry.getValue());
            if (!this._isAlive) continue;
            this._freeSlots.addAll((Collection<WorkerSlot>)entry.getValue());
        }
        this._topIdToUsedSlots = new HashMap<String, Set<WorkerSlot>>();
    }

    public void free(WorkerSlot ws, Cluster cluster2, boolean forceFree) {
        if (this._freeSlots.contains(ws)) {
            return;
        }
        boolean wasFound = false;
        for (Map.Entry<String, Set<WorkerSlot>> entry : this._topIdToUsedSlots.entrySet()) {
            Set<WorkerSlot> slots = entry.getValue();
            if (!slots.remove(ws)) continue;
            cluster2.freeSlot(ws);
            if (this._isAlive) {
                this._freeSlots.add(ws);
            }
            wasFound = true;
        }
        if (!wasFound) {
            if (forceFree) {
                LOG.info("Forcefully freeing the " + ws);
                cluster2.freeSlot(ws);
                this._freeSlots.add(ws);
            } else {
                throw new IllegalArgumentException("Tried to free a slot that was not part of this node " + this._nodeId);
            }
        }
    }

    public void freeTopology(String topId, Cluster cluster2) {
        Set<WorkerSlot> slots = this._topIdToUsedSlots.get(topId);
        if (slots == null || slots.isEmpty()) {
            return;
        }
        for (WorkerSlot ws : slots) {
            cluster2.freeSlot(ws);
            if (!this._isAlive) continue;
            this._freeSlots.add(ws);
        }
        this._topIdToUsedSlots.remove(topId);
    }

    public void assign(String topId, Collection<ExecutorDetails> executors, Cluster cluster2) {
        if (!this._isAlive) {
            throw new IllegalStateException("Trying to adding to a dead node " + this._nodeId);
        }
        if (this._freeSlots.isEmpty()) {
            throw new IllegalStateException("Trying to assign to a full node " + this._nodeId);
        }
        if (executors.size() == 0) {
            LOG.warn("Trying to assign nothing from " + topId + " to " + this._nodeId + " (Ignored)");
        } else {
            WorkerSlot slot = this._freeSlots.iterator().next();
            cluster2.assign(slot, topId, executors);
            this.assignInternal(slot, topId, false);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Node) {
            return this._nodeId.equals(((Node)other)._nodeId);
        }
        return false;
    }

    public int hashCode() {
        return this._nodeId.hashCode();
    }

    public String toString() {
        return "Node: " + this._nodeId;
    }

    public static int countSlotsUsed(String topId, Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            total += n.totalSlotsUsed(topId);
        }
        return total;
    }

    public static int countSlotsUsed(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            total += n.totalSlotsUsed();
        }
        return total;
    }

    public static int countFreeSlotsAlive(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlotsFree();
        }
        return total;
    }

    public static int countTotalSlotsAlive(Collection<Node> nodes) {
        int total = 0;
        for (Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlots();
        }
        return total;
    }

    public static Map<String, Node> getAllNodesFrom(Cluster cluster2) {
        HashMap<String, Node> nodeIdToNode = new HashMap<String, Node>();
        for (SupervisorDetails supervisorDetails : cluster2.getSupervisors().values()) {
            String id = supervisorDetails.getId();
            boolean isAlive = !cluster2.isBlackListed(id);
            LOG.debug("Found a {} Node {} {}", new Object[]{isAlive ? "living" : "dead", id, supervisorDetails.getAllPorts()});
            nodeIdToNode.put(id, new Node(id, supervisorDetails.getAllPorts(), isAlive));
        }
        for (Map.Entry entry : cluster2.getAssignments().entrySet()) {
            String topId = ((SchedulerAssignment)entry.getValue()).getTopologyId();
            for (WorkerSlot ws : ((SchedulerAssignment)entry.getValue()).getSlots()) {
                String id = ws.getNodeId();
                Node node = (Node)nodeIdToNode.get(id);
                if (node == null) {
                    LOG.debug("Found an assigned slot on a dead supervisor {}", (Object)ws);
                    node = new Node(id, null, false);
                    nodeIdToNode.put(id, node);
                }
                if (!node.isAlive()) {
                    node.addOrphanedSlot(ws);
                }
                if (!node.assignInternal(ws, topId, true)) continue;
                LOG.warn("Bad scheduling state for topology [" + topId + "], the slot " + ws + " assigned to multiple workers, un-assigning everything...");
                node.free(ws, cluster2, true);
            }
        }
        return nodeIdToNode;
    }
}

