/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.scheduler.multitenant;

import backtype.storm.scheduler.Cluster;
import backtype.storm.scheduler.IScheduler;
import backtype.storm.scheduler.Topologies;
import backtype.storm.scheduler.TopologyDetails;
import backtype.storm.scheduler.multitenant.DefaultPool;
import backtype.storm.scheduler.multitenant.FreePool;
import backtype.storm.scheduler.multitenant.IsolatedPool;
import backtype.storm.scheduler.multitenant.Node;
import backtype.storm.scheduler.multitenant.NodePool;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultitenantScheduler
implements IScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MultitenantScheduler.class);
    private Map _conf;

    @Override
    public void prepare(Map conf) {
        this._conf = conf;
    }

    private Map<String, Number> getUserConf() {
        HashMap<String, Number> ret = (HashMap<String, Number>)this._conf.get("multitenant.scheduler.user.pools");
        ret = ret == null ? new HashMap<String, Number>() : new HashMap(ret);
        Map fromFile = Utils.findAndReadConfigFile("multitenant-scheduler.yaml", false);
        Map tmp = (Map)fromFile.get("multitenant.scheduler.user.pools");
        if (tmp != null) {
            ret.putAll(tmp);
        }
        return ret;
    }

    @Override
    public void schedule(Topologies topologies, Cluster cluster2) {
        LOG.debug("Rerunning scheduling...");
        Map<String, Node> nodeIdToNode = Node.getAllNodesFrom(cluster2);
        Map<String, Number> userConf = this.getUserConf();
        HashMap<String, IsolatedPool> userPools = new HashMap<String, IsolatedPool>();
        for (Map.Entry<String, Number> entry : userConf.entrySet()) {
            userPools.put(entry.getKey(), new IsolatedPool(entry.getValue().intValue()));
        }
        DefaultPool defaultPool = new DefaultPool();
        FreePool freePool = new FreePool();
        freePool.init(cluster2, nodeIdToNode);
        for (IsolatedPool pool : userPools.values()) {
            pool.init(cluster2, nodeIdToNode);
        }
        defaultPool.init(cluster2, nodeIdToNode);
        for (TopologyDetails td : topologies.getTopologies()) {
            String user = (String)td.getConf().get("topology.submitter.user");
            LOG.debug("Found top {} run by user {}", (Object)td.getId(), (Object)user);
            NodePool pool = (NodePool)userPools.get(user);
            if (pool == null || !pool.canAdd(td)) {
                pool = defaultPool;
            }
            pool.addTopology(td);
        }
        for (IsolatedPool pool : userPools.values()) {
            pool.scheduleAsNeeded(freePool, defaultPool);
        }
        defaultPool.scheduleAsNeeded(freePool);
        LOG.debug("Scheduling done...");
    }
}

