/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.scheduler;

import backtype.storm.scheduler.ExecutorDetails;
import backtype.storm.scheduler.SchedulerAssignment;
import backtype.storm.scheduler.WorkerSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SchedulerAssignmentImpl
implements SchedulerAssignment {
    String topologyId;
    Map<ExecutorDetails, WorkerSlot> executorToSlot;

    public SchedulerAssignmentImpl(String topologyId, Map<ExecutorDetails, WorkerSlot> executorToSlots) {
        this.topologyId = topologyId;
        this.executorToSlot = new HashMap<ExecutorDetails, WorkerSlot>(0);
        if (executorToSlots != null) {
            this.executorToSlot.putAll(executorToSlots);
        }
    }

    @Override
    public Set<WorkerSlot> getSlots() {
        return new HashSet<WorkerSlot>(this.executorToSlot.values());
    }

    public void assign(WorkerSlot slot, Collection<ExecutorDetails> executors) {
        for (ExecutorDetails executor2 : executors) {
            this.executorToSlot.put(executor2, slot);
        }
    }

    public void unassignBySlot(WorkerSlot slot) {
        ArrayList<ExecutorDetails> executors = new ArrayList<ExecutorDetails>();
        for (ExecutorDetails executor2 : this.executorToSlot.keySet()) {
            WorkerSlot ws = this.executorToSlot.get(executor2);
            if (!ws.equals(slot)) continue;
            executors.add(executor2);
        }
        for (ExecutorDetails executor2 : executors) {
            this.executorToSlot.remove(executor2);
        }
    }

    @Override
    public boolean isSlotOccupied(WorkerSlot slot) {
        return this.executorToSlot.containsValue(slot);
    }

    @Override
    public boolean isExecutorAssigned(ExecutorDetails executor2) {
        return this.executorToSlot.containsKey(executor2);
    }

    @Override
    public String getTopologyId() {
        return this.topologyId;
    }

    @Override
    public Map<ExecutorDetails, WorkerSlot> getExecutorToSlot() {
        return this.executorToSlot;
    }

    @Override
    public Set<ExecutorDetails> getExecutors() {
        return this.executorToSlot.keySet();
    }
}

