/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.multilang;

import backtype.storm.multilang.BoltMsg;
import backtype.storm.multilang.ISerializer;
import backtype.storm.multilang.NoOutputException;
import backtype.storm.multilang.ShellMsg;
import backtype.storm.multilang.SpoutMsg;
import backtype.storm.task.TopologyContext;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.json.simple.JSONObject;
import org.apache.storm.shade.org.json.simple.JSONValue;

public class JsonSerializer
implements ISerializer {
    private DataOutputStream processIn;
    private BufferedReader processOut;

    @Override
    public void initialize(OutputStream processIn, InputStream processOut) {
        this.processIn = new DataOutputStream(processIn);
        try {
            this.processOut = new BufferedReader(new InputStreamReader(processOut, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Number connect(Map conf, TopologyContext context2) throws IOException, NoOutputException {
        JSONObject setupInfo = new JSONObject();
        setupInfo.put("pidDir", context2.getPIDDir());
        setupInfo.put("conf", conf);
        setupInfo.put("context", context2);
        this.writeMessage(setupInfo);
        Number pid = (Number)((JSONObject)this.readMessage()).get("pid");
        return pid;
    }

    @Override
    public void writeBoltMsg(BoltMsg boltMsg) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("id", boltMsg.getId());
        obj.put("comp", boltMsg.getComp());
        obj.put("stream", boltMsg.getStream());
        obj.put("task", boltMsg.getTask());
        obj.put("tuple", boltMsg.getTuple());
        this.writeMessage(obj);
    }

    @Override
    public void writeSpoutMsg(SpoutMsg msg) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("command", msg.getCommand());
        obj.put("id", msg.getId());
        this.writeMessage(obj);
    }

    @Override
    public void writeTaskIds(List<Integer> taskIds) throws IOException {
        this.writeMessage(taskIds);
    }

    private void writeMessage(Object msg) throws IOException {
        this.writeString(JSONValue.toJSONString(msg));
    }

    private void writeString(String str) throws IOException {
        byte[] strBytes = str.getBytes("UTF-8");
        this.processIn.write(strBytes, 0, strBytes.length);
        this.processIn.writeBytes("\nend\n");
        this.processIn.flush();
    }

    @Override
    public ShellMsg readShellMsg() throws IOException, NoOutputException {
        Object logLevelObj;
        JSONObject msg = (JSONObject)this.readMessage();
        ShellMsg shellMsg = new ShellMsg();
        String command = (String)msg.get("command");
        shellMsg.setCommand(command);
        Object id = msg.get("id");
        shellMsg.setId(id);
        String log2 = (String)msg.get("msg");
        shellMsg.setMsg(log2);
        String stream = (String)msg.get("stream");
        if (stream == null) {
            stream = "default";
        }
        shellMsg.setStream(stream);
        Object taskObj = msg.get("task");
        if (taskObj != null) {
            shellMsg.setTask((Long)taskObj);
        } else {
            shellMsg.setTask(0L);
        }
        Object need_task_ids = msg.get("need_task_ids");
        if (need_task_ids == null || ((Boolean)need_task_ids).booleanValue()) {
            shellMsg.setNeedTaskIds(true);
        } else {
            shellMsg.setNeedTaskIds(false);
        }
        shellMsg.setTuple((List)msg.get("tuple"));
        ArrayList anchors = new ArrayList();
        Object anchorObj = msg.get("anchors");
        if (anchorObj != null) {
            if (anchorObj instanceof String) {
                anchorObj = Arrays.asList(anchorObj);
            }
            for (Object o : (List)anchorObj) {
                shellMsg.addAnchor((String)o);
            }
        }
        Object nameObj = msg.get("name");
        String metricName = null;
        if (nameObj != null && nameObj instanceof String) {
            metricName = (String)nameObj;
        }
        shellMsg.setMetricName(metricName);
        Object paramsObj = msg.get("params");
        shellMsg.setMetricParams(paramsObj);
        if (command.equals("log") && (logLevelObj = msg.get("level")) != null && logLevelObj instanceof Long) {
            long logLevel = (Long)logLevelObj;
            shellMsg.setLogLevel((int)logLevel);
        }
        return shellMsg;
    }

    private Object readMessage() throws IOException, NoOutputException {
        String string = this.readString();
        Object msg = JSONValue.parse(string);
        if (msg != null) {
            return msg;
        }
        throw new IOException("unable to parse: " + string);
    }

    private String readString() throws IOException, NoOutputException {
        StringBuilder line = new StringBuilder();
        while (true) {
            String subline;
            if ((subline = this.processOut.readLine()) == null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Pipe to subprocess seems to be broken!");
                if (line.length() == 0) {
                    errorMessage.append(" No output read.\n");
                } else {
                    errorMessage.append(" Currently read output: " + line.toString() + "\n");
                }
                errorMessage.append("Serializer Exception:\n");
                throw new NoOutputException(errorMessage.toString());
            }
            if (subline.equals("end")) break;
            if (line.length() != 0) {
                line.append("\n");
            }
            line.append(subline);
        }
        return line.toString();
    }
}

