/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.metric;

import backtype.storm.metric.api.IMetric;
import backtype.storm.task.IBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Tuple;
import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.RT;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemBolt
implements IBolt {
    private static Logger LOG = LoggerFactory.getLogger(SystemBolt.class);
    private static boolean _prepareWasCalled = false;

    @Override
    public void prepare(Map stormConf, TopologyContext context2, OutputCollector collector) {
        if (_prepareWasCalled && !"local".equals(stormConf.get("storm.cluster.mode"))) {
            throw new RuntimeException("A single worker should have 1 SystemBolt instance.");
        }
        _prepareWasCalled = true;
        int bucketSize = RT.intCast(stormConf.get("topology.builtin.metrics.bucket.size.secs"));
        final RuntimeMXBean jvmRT = ManagementFactory.getRuntimeMXBean();
        context2.registerMetric("uptimeSecs", new IMetric(){

            @Override
            public Object getValueAndReset() {
                return (double)jvmRT.getUptime() / 1000.0;
            }
        }, bucketSize);
        context2.registerMetric("startTimeSecs", new IMetric(){

            @Override
            public Object getValueAndReset() {
                return (double)jvmRT.getStartTime() / 1000.0;
            }
        }, bucketSize);
        context2.registerMetric("newWorkerEvent", new IMetric(){
            boolean doEvent = true;

            @Override
            public Object getValueAndReset() {
                if (this.doEvent) {
                    this.doEvent = false;
                    return 1;
                }
                return 0;
            }
        }, bucketSize);
        final MemoryMXBean jvmMemRT = ManagementFactory.getMemoryMXBean();
        context2.registerMetric("memory/heap", new MemoryUsageMetric((IFn)new AFn(){

            public Object invoke() {
                return jvmMemRT.getHeapMemoryUsage();
            }
        }), bucketSize);
        context2.registerMetric("memory/nonHeap", new MemoryUsageMetric((IFn)new AFn(){

            public Object invoke() {
                return jvmMemRT.getNonHeapMemoryUsage();
            }
        }), bucketSize);
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            context2.registerMetric("GC/" + b.getName().replaceAll("\\W", ""), new GarbageCollectorMetric(b), bucketSize);
        }
    }

    @Override
    public void execute(Tuple input) {
        throw new RuntimeException("Non-system tuples should never be sent to __system bolt.");
    }

    @Override
    public void cleanup() {
    }

    private static class GarbageCollectorMetric
    implements IMetric {
        GarbageCollectorMXBean _gcBean;
        Long _collectionCount;
        Long _collectionTime;

        public GarbageCollectorMetric(GarbageCollectorMXBean gcBean) {
            this._gcBean = gcBean;
        }

        @Override
        public Object getValueAndReset() {
            Long collectionCountP = this._gcBean.getCollectionCount();
            Long collectionTimeP = this._gcBean.getCollectionTime();
            HashMap<String, Long> ret = null;
            if (this._collectionCount != null && this._collectionTime != null) {
                ret = new HashMap<String, Long>();
                ret.put("count", collectionCountP - this._collectionCount);
                ret.put("timeMs", collectionTimeP - this._collectionTime);
            }
            this._collectionCount = collectionCountP;
            this._collectionTime = collectionTimeP;
            return ret;
        }
    }

    private static class MemoryUsageMetric
    implements IMetric {
        IFn _getUsage;

        public MemoryUsageMetric(IFn getUsage) {
            this._getUsage = getUsage;
        }

        @Override
        public Object getValueAndReset() {
            MemoryUsage memUsage = (MemoryUsage)this._getUsage.invoke();
            HashMap<String, Long> m = new HashMap<String, Long>();
            m.put("maxBytes", memUsage.getMax());
            m.put("committedBytes", memUsage.getCommitted());
            m.put("initBytes", memUsage.getInit());
            m.put("usedBytes", memUsage.getUsed());
            m.put("virtualFreeBytes", memUsage.getMax() - memUsage.getUsed());
            m.put("unusedBytes", memUsage.getCommitted() - memUsage.getUsed());
            return m;
        }
    }
}

