/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.MessageDecoder;
import backtype.storm.messaging.netty.MessageEncoder;
import backtype.storm.messaging.netty.SaslStormServerAuthorizeHandler;
import backtype.storm.messaging.netty.SaslStormServerHandler;
import backtype.storm.messaging.netty.Server;
import backtype.storm.messaging.netty.StormServerHandler;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipeline;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipelineFactory;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;

class StormServerPipelineFactory
implements ChannelPipelineFactory {
    private Server server;

    StormServerPipelineFactory(Server server) {
        this.server = server;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new MessageDecoder());
        pipeline.addLast("encoder", new MessageEncoder());
        boolean isNettyAuth = (Boolean)this.server.storm_conf.get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslServerHandler", new SaslStormServerHandler(this.server));
            pipeline.addLast("authorizeServerHandler", new SaslStormServerAuthorizeHandler());
        }
        pipeline.addLast("handler", new StormServerHandler(this.server));
        return pipeline;
    }
}

