/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.Server;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ExceptionEvent;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StormServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StormServerHandler.class);
    Server server;
    private AtomicInteger failure_count;

    StormServerHandler(Server server) {
        this.server = server;
        this.failure_count = new AtomicInteger(0);
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.server.addChannel(e.getChannel());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        List msgs = (List)e.getMessage();
        if (msgs == null) {
            return;
        }
        try {
            this.server.enqueue(msgs, e.getRemoteAddress().toString());
        }
        catch (InterruptedException e1) {
            LOG.info("failed to enqueue a request message", (Object)e);
            this.failure_count.incrementAndGet();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.error("server errors in handling the request", e.getCause());
        this.server.closeChannel(e.getChannel());
    }
}

