/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.Client;
import backtype.storm.messaging.netty.MessageDecoder;
import backtype.storm.messaging.netty.MessageEncoder;
import backtype.storm.messaging.netty.SaslStormClientHandler;
import backtype.storm.messaging.netty.StormClientHandler;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipeline;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipelineFactory;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;

class StormClientPipelineFactory
implements ChannelPipelineFactory {
    private Client client;

    StormClientPipelineFactory(Client client) {
        this.client = client;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new MessageDecoder());
        pipeline.addLast("encoder", new MessageEncoder());
        boolean isNettyAuth = (Boolean)this.client.getStormConf().get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslClientHandler", new SaslStormClientHandler(this.client));
        }
        pipeline.addLast("handler", new StormClientHandler(this.client));
        return pipeline;
    }
}

