/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.ConnectionWithStatus;
import backtype.storm.messaging.TaskMessage;
import backtype.storm.messaging.netty.NettyRenameThreadFactory;
import backtype.storm.messaging.netty.StormServerPipelineFactory;
import backtype.storm.metric.api.IStatefulObject;
import backtype.storm.utils.Utils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.shade.org.jboss.netty.bootstrap.ServerBootstrap;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFactory;
import org.apache.storm.shade.org.jboss.netty.channel.group.ChannelGroup;
import org.apache.storm.shade.org.jboss.netty.channel.group.DefaultChannelGroup;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Server
extends ConnectionWithStatus
implements IStatefulObject {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    Map storm_conf;
    int port;
    private final ConcurrentHashMap<String, AtomicInteger> messagesEnqueued = new ConcurrentHashMap();
    private final AtomicInteger messagesDequeued = new AtomicInteger(0);
    private final AtomicInteger[] pendingMessages;
    private LinkedBlockingQueue<ArrayList<TaskMessage>>[] message_queue;
    volatile ChannelGroup allChannels = new DefaultChannelGroup("storm-server");
    final ChannelFactory factory;
    final ServerBootstrap bootstrap;
    private int queueCount;
    private volatile HashMap<Integer, Integer> taskToQueueId = null;
    int roundRobinQueueId;
    private volatile boolean closing = false;
    List<TaskMessage> closeMessage = Arrays.asList(new TaskMessage(-1, null));

    Server(Map storm_conf, int port) {
        this.storm_conf = storm_conf;
        this.port = port;
        this.queueCount = Utils.getInt(storm_conf.get("topology.worker.receiver.thread.count"), 1);
        this.roundRobinQueueId = 0;
        this.taskToQueueId = new HashMap();
        this.message_queue = new LinkedBlockingQueue[this.queueCount];
        this.pendingMessages = new AtomicInteger[this.queueCount];
        for (int i = 0; i < this.queueCount; ++i) {
            this.message_queue[i] = new LinkedBlockingQueue();
            this.pendingMessages[i] = new AtomicInteger(0);
        }
        int buffer_size = Utils.getInt(storm_conf.get("storm.messaging.netty.buffer_size"));
        int backlog = Utils.getInt(storm_conf.get("storm.messaging.netty.socket.backlog"), 500);
        int maxWorkers = Utils.getInt(storm_conf.get("storm.messaging.netty.server_worker_threads"));
        NettyRenameThreadFactory bossFactory = new NettyRenameThreadFactory(this.name() + "-boss");
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory(this.name() + "-worker");
        this.factory = maxWorkers > 0 ? new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory), maxWorkers) : new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory));
        LOG.info("Create Netty Server " + this.name() + ", buffer_size: " + buffer_size + ", maxWorkers: " + maxWorkers);
        this.bootstrap = new ServerBootstrap(this.factory);
        this.bootstrap.setOption("child.tcpNoDelay", true);
        this.bootstrap.setOption("child.receiveBufferSize", buffer_size);
        this.bootstrap.setOption("child.keepAlive", true);
        this.bootstrap.setOption("backlog", backlog);
        this.bootstrap.setPipelineFactory(new StormServerPipelineFactory(this));
        Channel channel = this.bootstrap.bind(new InetSocketAddress(port));
        this.allChannels.add(channel);
    }

    private ArrayList<TaskMessage>[] groupMessages(List<TaskMessage> msgs) {
        ArrayList[] messageGroups = new ArrayList[this.queueCount];
        for (int i = 0; i < msgs.size(); ++i) {
            TaskMessage message = msgs.get(i);
            int task2 = message.task();
            if (task2 == -1) {
                this.closing = true;
                return null;
            }
            Integer queueId = this.getMessageQueueId(task2);
            if (null == messageGroups[queueId]) {
                messageGroups[queueId.intValue()] = new ArrayList();
            }
            messageGroups[queueId].add(message);
        }
        return messageGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMessageQueueId(int task2) {
        Integer queueId = this.taskToQueueId.get(task2);
        if (null == queueId) {
            Server server = this;
            synchronized (server) {
                queueId = this.taskToQueueId.get(task2);
                if (queueId == null) {
                    queueId = this.roundRobinQueueId++;
                    if (this.roundRobinQueueId == this.queueCount) {
                        this.roundRobinQueueId = 0;
                    }
                    HashMap<Integer, Integer> newRef = new HashMap<Integer, Integer>(this.taskToQueueId);
                    newRef.put(task2, queueId);
                    this.taskToQueueId = newRef;
                }
            }
        }
        return queueId;
    }

    private void addReceiveCount(String from, int amount) {
        AtomicInteger i = this.messagesEnqueued.get(from);
        if (i == null) {
            i = new AtomicInteger(amount);
            AtomicInteger prev = this.messagesEnqueued.putIfAbsent(from, i);
            if (prev != null) {
                prev.addAndGet(amount);
            }
        } else {
            i.addAndGet(amount);
        }
    }

    protected void enqueue(List<TaskMessage> msgs, String from) throws InterruptedException {
        if (null == msgs || msgs.size() == 0 || this.closing) {
            return;
        }
        this.addReceiveCount(from, msgs.size());
        ArrayList<TaskMessage>[] messageGroups = this.groupMessages(msgs);
        if (null == messageGroups || this.closing) {
            return;
        }
        for (int receiverId = 0; receiverId < messageGroups.length; ++receiverId) {
            ArrayList<TaskMessage> msgGroup = messageGroups[receiverId];
            if (null == msgGroup) continue;
            this.message_queue[receiverId].put(msgGroup);
            this.pendingMessages[receiverId].addAndGet(msgGroup.size());
        }
    }

    @Override
    public Iterator<TaskMessage> recv(int flags, int receiverId) {
        if (this.closing) {
            return this.closeMessage.iterator();
        }
        ArrayList<TaskMessage> ret = null;
        int queueId = receiverId % this.queueCount;
        if ((flags & 1) == 1) {
            ret = this.message_queue[queueId].poll();
        } else {
            try {
                ArrayList<TaskMessage> request = this.message_queue[queueId].take();
                LOG.debug("request to be processed: {}", request);
                ret = request;
            }
            catch (InterruptedException e) {
                LOG.info("exception within msg receiving", (Throwable)e);
                ret = null;
            }
        }
        if (null != ret) {
            this.messagesDequeued.addAndGet(ret.size());
            this.pendingMessages[queueId].addAndGet(0 - ret.size());
            return ret.iterator();
        }
        return null;
    }

    protected void addChannel(Channel channel) {
        this.allChannels.add(channel);
    }

    protected void closeChannel(Channel channel) {
        channel.close().awaitUninterruptibly();
        this.allChannels.remove(channel);
    }

    @Override
    public synchronized void close() {
        if (this.allChannels != null) {
            this.allChannels.close().awaitUninterruptibly();
            this.factory.releaseExternalResources();
            this.allChannels = null;
        }
    }

    @Override
    public void send(int task2, byte[] message) {
        throw new UnsupportedOperationException("Server connection should not send any messages");
    }

    @Override
    public void send(Iterator<TaskMessage> msgs) {
        throw new UnsupportedOperationException("Server connection should not send any messages");
    }

    public String name() {
        return "Netty-server-localhost-" + this.port;
    }

    @Override
    public ConnectionWithStatus.Status status() {
        if (this.closing) {
            return ConnectionWithStatus.Status.Closed;
        }
        if (!this.connectionEstablished(this.allChannels)) {
            return ConnectionWithStatus.Status.Connecting;
        }
        return ConnectionWithStatus.Status.Ready;
    }

    private boolean connectionEstablished(Channel channel) {
        return channel != null && channel.isBound();
    }

    private boolean connectionEstablished(ChannelGroup allChannels) {
        boolean allEstablished = true;
        for (Channel channel : allChannels) {
            if (this.connectionEstablished(channel)) continue;
            allEstablished = false;
            break;
        }
        return allEstablished;
    }

    @Override
    public Object getState() {
        LOG.info("Getting metrics for server on port {}", (Object)this.port);
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("dequeuedMessages", Integer.valueOf(this.messagesDequeued.getAndSet(0)));
        ArrayList<Integer> pending = new ArrayList<Integer>(this.pendingMessages.length);
        for (AtomicInteger p : this.pendingMessages) {
            pending.add(p.get());
        }
        ret.put("pending", pending);
        HashMap<String, Integer> enqueued = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, AtomicInteger>> it = this.messagesEnqueued.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, AtomicInteger> ent = it.next();
            AtomicInteger i = ent.getValue();
            if (i.get() == 0) {
                it.remove();
                continue;
            }
            enqueued.put(ent.getKey(), i.getAndSet(0));
        }
        ret.put("enqueued", enqueued);
        return ret;
    }

    public String toString() {
        return String.format("Netty server listening on port %s", this.port);
    }
}

