/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.codec.binary.Base64;
import org.apache.storm.shade.org.apache.commons.io.Charsets;

class SaslUtils {
    public static final String AUTH_DIGEST_MD5 = "DIGEST-MD5";
    public static final String DEFAULT_REALM = "default";

    SaslUtils() {
    }

    static Map<String, String> getSaslProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.policy.noplaintext", "true");
        return props;
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64(password), Charsets.UTF_8).toCharArray();
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64(identifier), Charsets.UTF_8);
    }

    static String getSecretKey(Map conf) {
        if (conf == null || conf.isEmpty()) {
            return null;
        }
        String secretPayLoad = (String)conf.get("storm.zookeeper.topology.auth.payload");
        return secretPayLoad;
    }
}

