/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.ControlMessage;
import backtype.storm.messaging.netty.SaslMessageToken;
import backtype.storm.messaging.netty.SaslNettyServer;
import backtype.storm.messaging.netty.SaslNettyServerState;
import backtype.storm.messaging.netty.SaslUtils;
import backtype.storm.messaging.netty.Server;
import java.io.IOException;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.ExceptionEvent;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormServerHandler
extends SimpleChannelUpstreamHandler {
    Server server;
    private byte[] token;
    private String topologyName;
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormServerHandler.class);

    public SaslStormServerHandler(Server server) throws IOException {
        this.server = server;
        this.getSASLCredentials();
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg == null) {
            return;
        }
        Channel channel = ctx.getChannel();
        if (msg instanceof ControlMessage && (ControlMessage)((Object)e.getMessage()) == ControlMessage.SASL_TOKEN_MESSAGE_REQUEST) {
            SaslNettyServer saslNettyServer = SaslNettyServerState.getSaslNettyServer.get(channel);
            if (saslNettyServer == null) {
                LOG.debug("No saslNettyServer for " + channel + " yet; creating now, with topology token: ");
                try {
                    saslNettyServer = new SaslNettyServer(this.topologyName, this.token);
                }
                catch (IOException ioe) {
                    LOG.error("Error occurred while creating saslNettyServer on server " + channel.getLocalAddress() + " for client " + channel.getRemoteAddress());
                    saslNettyServer = null;
                }
                SaslNettyServerState.getSaslNettyServer.set(channel, saslNettyServer);
            } else {
                LOG.debug("Found existing saslNettyServer on server:" + channel.getLocalAddress() + " for client " + channel.getRemoteAddress());
            }
            LOG.debug("processToken:  With nettyServer: " + saslNettyServer + " and token length: " + this.token.length);
            SaslMessageToken saslTokenMessageRequest = null;
            saslTokenMessageRequest = new SaslMessageToken(saslNettyServer.response(new byte[0]));
            channel.write(saslTokenMessageRequest);
            return;
        }
        if (msg instanceof SaslMessageToken) {
            SaslNettyServer saslNettyServer = SaslNettyServerState.getSaslNettyServer.get(channel);
            if (saslNettyServer == null && saslNettyServer == null) {
                throw new Exception("saslNettyServer was unexpectedly null for channel: " + channel);
            }
            SaslMessageToken saslTokenMessageRequest = new SaslMessageToken(saslNettyServer.response(((SaslMessageToken)msg).getSaslToken()));
            channel.write(saslTokenMessageRequest);
            if (saslNettyServer.isComplete()) {
                LOG.debug("SASL authentication is complete for client with username: " + saslNettyServer.getUserName());
                channel.write((Object)ControlMessage.SASL_COMPLETE_REQUEST);
                LOG.debug("Removing SaslServerHandler from pipeline since SASL authentication is complete.");
                ctx.getPipeline().remove(this);
            }
            return;
        }
        LOG.warn("Sending upstream an unexpected non-SASL message :  " + msg);
        Channels.fireMessageReceived(ctx, msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.server.closeChannel(e.getChannel());
    }

    private void getSASLCredentials() throws IOException {
        this.topologyName = (String)this.server.storm_conf.get("topology.name");
        String secretKey = SaslUtils.getSecretKey(this.server.storm_conf);
        if (secretKey != null) {
            this.token = secretKey.getBytes();
        }
        LOG.debug("SASL credentials for storm topology " + this.topologyName + " is " + secretKey);
    }
}

