/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.SaslNettyServer;
import backtype.storm.messaging.netty.SaslNettyServerState;
import backtype.storm.messaging.netty.SaslStormServerHandler;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormServerAuthorizeHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormServerHandler.class);

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object msg = e.getMessage();
        if (msg == null) {
            return;
        }
        Channel channel = ctx.getChannel();
        LOG.debug("messageReceived: Checking whether the client is authorized to send messages to the server ");
        SaslNettyServer saslNettyServer = SaslNettyServerState.getSaslNettyServer.get(channel);
        if (saslNettyServer == null) {
            LOG.warn("messageReceived: This client is *NOT* authorized to perform this action since there's no saslNettyServer to authenticate the client: refusing to perform requested action: " + msg);
            return;
        }
        if (!saslNettyServer.isComplete()) {
            LOG.warn("messageReceived: This client is *NOT* authorized to perform this action because SASL authentication did not complete: refusing to perform requested action: " + msg);
            return;
        }
        LOG.debug("messageReceived: authenticated client: " + saslNettyServer.getUserName() + " is authorized to do request " + "on server.");
        Channels.fireMessageReceived(ctx, msg);
    }
}

