/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.netty.Client;
import backtype.storm.messaging.netty.ControlMessage;
import backtype.storm.messaging.netty.SaslMessageToken;
import backtype.storm.messaging.netty.SaslNettyClient;
import backtype.storm.messaging.netty.SaslNettyClientState;
import backtype.storm.messaging.netty.SaslUtils;
import java.io.IOException;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormClientHandler.class);
    private Client client;
    long start_time;
    private byte[] token;
    private String topologyName;

    public SaslStormClientHandler(Client client) throws IOException {
        this.client = client;
        this.start_time = System.currentTimeMillis();
        this.getSASLCredentials();
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event2) {
        Channel channel = ctx.getChannel();
        LOG.info("Connection established from " + channel.getLocalAddress() + " to " + channel.getRemoteAddress());
        try {
            SaslNettyClient saslNettyClient = SaslNettyClientState.getSaslNettyClient.get(channel);
            if (saslNettyClient == null) {
                LOG.debug("Creating saslNettyClient now for channel: " + channel);
                saslNettyClient = new SaslNettyClient(this.topologyName, this.token);
                SaslNettyClientState.getSaslNettyClient.set(channel, saslNettyClient);
            }
            channel.write((Object)ControlMessage.SASL_TOKEN_MESSAGE_REQUEST);
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with server due to error: ", (Throwable)e);
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event2) throws Exception {
        ControlMessage msg;
        LOG.debug("send/recv time (ms): {}", (Object)(System.currentTimeMillis() - this.start_time));
        Channel channel = ctx.getChannel();
        SaslNettyClient saslNettyClient = SaslNettyClientState.getSaslNettyClient.get(channel);
        if (saslNettyClient == null) {
            throw new Exception("saslNettyClient was unexpectedly null for channel: " + channel);
        }
        if (event2.getMessage() instanceof ControlMessage && (msg = (ControlMessage)((Object)event2.getMessage())) == ControlMessage.SASL_COMPLETE_REQUEST) {
            LOG.debug("Server has sent us the SaslComplete message. Allowing normal work to proceed.");
            if (!saslNettyClient.isComplete()) {
                LOG.error("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
                throw new Exception("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
            }
            ctx.getPipeline().remove(this);
            Channels.fireMessageReceived(ctx, (Object)msg);
            return;
        }
        SaslMessageToken saslTokenMessage = (SaslMessageToken)event2.getMessage();
        LOG.debug("Responding to server's token of length: " + saslTokenMessage.getSaslToken().length);
        byte[] responseToServer = saslNettyClient.saslResponse(saslTokenMessage);
        if (responseToServer == null) {
            LOG.debug("Response to server is null: authentication should now be complete.");
            if (!saslNettyClient.isComplete()) {
                LOG.warn("Generated a null response, but authentication is not complete.");
                throw new Exception("Server reponse is null, but as far as we can tell, we are not authenticated yet.");
            }
            return;
        }
        LOG.debug("Response to server token has length:" + responseToServer.length);
        SaslMessageToken saslResponse = new SaslMessageToken(responseToServer);
        channel.write(saslResponse);
    }

    private void getSASLCredentials() throws IOException {
        this.topologyName = (String)this.client.getStormConf().get("topology.name");
        String secretKey = SaslUtils.getSecretKey(this.client.getStormConf());
        if (secretKey != null) {
            this.token = secretKey.getBytes();
        }
        LOG.debug("SASL credentials for storm topology " + this.topologyName + " is " + secretKey);
    }
}

