/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMessageToken {
    private static final Logger LOG = LoggerFactory.getLogger(SaslMessageToken.class);
    private byte[] token;

    public SaslMessageToken() {
    }

    public SaslMessageToken(byte[] token) {
        this.token = token;
    }

    public byte[] getSaslToken() {
        return this.token;
    }

    public void setSaslToken(byte[] token) {
        this.token = token;
    }

    int encodeLength() {
        return 6 + this.token.length;
    }

    ChannelBuffer buffer() throws Exception {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer(this.encodeLength()));
        int identifier = -500;
        int payload_len = 0;
        if (this.token != null) {
            payload_len = this.token.length;
        }
        bout.writeShort(identifier);
        bout.writeInt(payload_len);
        if (payload_len > 0) {
            bout.write(this.token);
        }
        bout.close();
        return bout.buffer();
    }
}

