/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.shade.org.jboss.netty.util.ThreadNameDeterminer;
import org.apache.storm.shade.org.jboss.netty.util.ThreadRenamingRunnable;

public class NettyRenameThreadFactory
implements ThreadFactory {
    final ThreadGroup group;
    final AtomicInteger index = new AtomicInteger(1);
    final String name;

    NettyRenameThreadFactory(String name) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.name = name;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.name + "-" + this.index.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    static {
        ThreadRenamingRunnable.setThreadNameDeterminer(ThreadNameDeterminer.CURRENT);
    }
}

