/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.TaskMessage;
import backtype.storm.messaging.netty.ControlMessage;
import backtype.storm.messaging.netty.SaslMessageToken;
import java.util.ArrayList;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.handler.codec.frame.FrameDecoder;

public class MessageDecoder
extends FrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) throws Exception {
        long available = buf.readableBytes();
        if (available < 2L) {
            return null;
        }
        ArrayList<TaskMessage> ret = new ArrayList<TaskMessage>();
        while (available >= 2L) {
            buf.markReaderIndex();
            short code = buf.readShort();
            available -= 2L;
            ControlMessage ctrl_msg = ControlMessage.mkMessage(code);
            if (ctrl_msg != null) {
                if (ctrl_msg == ControlMessage.EOB_MESSAGE) continue;
                return ctrl_msg;
            }
            if (code == -500) {
                if (buf.readableBytes() < 4) {
                    buf.resetReaderIndex();
                    return null;
                }
                int length = buf.readInt();
                if (length <= 0) {
                    return new SaslMessageToken(null);
                }
                if (buf.readableBytes() < length) {
                    buf.resetReaderIndex();
                    return null;
                }
                ChannelBuffer payload = buf.readBytes(length);
                return new SaslMessageToken(payload.array());
            }
            short task2 = code;
            if (available < 4L) {
                buf.resetReaderIndex();
                break;
            }
            int length = buf.readInt();
            available -= 4L;
            if (length <= 0) {
                ret.add(new TaskMessage(task2, null));
                break;
            }
            if (available < (long)length) {
                buf.resetReaderIndex();
                break;
            }
            available -= (long)length;
            ChannelBuffer payload = buf.readBytes(length);
            ret.add(new TaskMessage(task2, payload.array()));
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }
}

